/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.scoping;

import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertSame;

import static org.springframework.config.java.util.DefaultScopes.PROTOTYPE;

import org.junit.Test;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;

import test.common.beans.TestBean;


/**
 * Integration tests proving that scoping works as intended.
 *
 * @see ScopingTests
 * @author  Chris Beams
 */
public class ScopeIntegrationTests {

    @Test
    public void singleton() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(SingletonConfig.class);
        TestBean t1 = ctx.getBean(TestBean.class);
        TestBean t2 = ctx.getBean(TestBean.class);
        assertSame(t1, t2);
    }

    @Test
    public void prototype() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(PrototypeConfig.class);
        TestBean t1 = ctx.getBean(TestBean.class);
        TestBean t2 = ctx.getBean(TestBean.class);
        assertNotSame(t1, t2);
    }

    @Configuration
    static class SingletonConfig {
        @Bean
        public TestBean singleton() { return new TestBean("singleton"); }
    }

    @Configuration
    static class PrototypeConfig {
        @Bean(scope = PROTOTYPE)
        public TestBean prototype() { return new TestBean("prototype"); }
    }

}
