/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.context;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.config.java.aspect.RequiredMethodInvocationTracker;
import org.springframework.config.java.plugin.Plugin;
import org.springframework.config.java.plugin.tx.AnnotationDrivenTx;


/**
 * Activates various annotations to be detected in bean classes: Spring's
 * {@code @Autowired}, as well as JSR 250's {@code @PostConstruct},
 * {@code @PreDestroy} and {@code @Resource} (if available),
 * JAX-WS's {@code @WebServiceRef} (if available), EJB3's {@code @EJB}
 * (if available), and JPA's {@code @PersistenceContext} and
 * {@code @PersistenceUnit} (if available). Alternatively, you may
 * choose to activate the individual BeanPostProcessors for those annotations.
 * <p/>
 * <strong>Note</strong>: Unlike its {@code <context:annotation-config/>}
 * XML counterpart, this annotation does not trigger the detection and handling of
 * {@code @Required} methods. Due to fundamental differences between how JavaConfig
 * and XML work, this must be enabled via AspectJ.  See
 * {@link RequiredMethodInvocationTracker RequiredMethodInvocationTracker}
 * for more details.
 * <p/>
 * <strong>Note</strong>: This tag does not activate processing of Spring's
 * {@code @Transactional} or EJB3's {@code @TransactionAttribute} annotation.
 * Consider the use of {@link AnnotationDrivenTx} for that purpose.
 *
 * @author Chris Beams
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
@Plugin(handler=AnnotationDrivenConfigHandler.class)
public @interface AnnotationDrivenConfig { }
