/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.util;


/**
 * Commonly-used bean metadata pairs.
 * <p/>
 * TODO: SJC-209: slated for elimination along with bean visibility in general.
 *
 * Use:<p/>
 * <pre>
 * import static org.springframework.config.java.util.BeanMetadata.COPY_HIDDEN;
 *
 * &#64;Bean(meta=@Meta(key=COPY_HIDDEN, value="true"))
 * public Object myBean() {
 *     return new Object();
 * }
 * </pre>
 *
 * @author  Chris Beams
 * @see     org.springframework.config.java.annotation.Meta
 */
public class BeanMetadata {

    /**
     * Signifies that an otherwise public (visible) bean should be copied to the JavaConfig-internal
     * BeanFactory. Primarily used for propagating BeanFactoryPostProcessor beans such that both
     * hidden and visible bean definitions are post-processed.
     *
     * <p>value is irrelevant when using {@link #COPY_HIDDEN}, but use 'true' by convention.</p>
     */
    public static final String COPY_HIDDEN = "COPY_HIDDEN";

}
