/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */
package org.apache.camel.dataformat.avro.example;

import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.SpecificData;

@org.apache.avro.specific.AvroGenerated
public class DateRecord extends org.apache.avro.specific.SpecificRecordBase implements org.apache.avro.specific.SpecificRecord {
    private static final long serialVersionUID = 8653491882695437570L;

    public static final org.apache.avro.Schema SCHEMA$ = new org.apache.avro.Schema.Parser().parse(
            "{\"type\":\"record\",\"name\":\"DateRecord\",\"namespace\":\"org.apache.camel.dataformat.avro.example\",\"fields\":[{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}],\"default\":null},{\"name\":\"timestamp\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}],\"default\":null}]}");

    public static org.apache.avro.Schema getClassSchema() {
        return SCHEMA$;
    }

    private static final SpecificData MODEL$ = new SpecificData();
    static {
        MODEL$.addLogicalTypeConversion(new org.apache.avro.data.TimeConversions.DateConversion());
        MODEL$.addLogicalTypeConversion(new org.apache.avro.data.TimeConversions.TimestampMillisConversion());
    }

    private static final BinaryMessageEncoder<DateRecord> ENCODER = new BinaryMessageEncoder<>(MODEL$, SCHEMA$);

    private static final BinaryMessageDecoder<DateRecord> DECODER = new BinaryMessageDecoder<>(MODEL$, SCHEMA$);

    /**
     * Return the BinaryMessageEncoder instance used by this class.
     *
     * @return the message encoder used by this class
     */
    public static BinaryMessageEncoder<DateRecord> getEncoder() {
        return ENCODER;
    }

    /**
     * Return the BinaryMessageDecoder instance used by this class.
     *
     * @return the message decoder used by this class
     */
    public static BinaryMessageDecoder<DateRecord> getDecoder() {
        return DECODER;
    }

    /**
     * Create a new BinaryMessageDecoder instance for this class that uses the specified {@link SchemaStore}.
     *
     * @param  resolver a {@link SchemaStore} used to find schemas by fingerprint
     * @return          a BinaryMessageDecoder instance for this class backed by the given SchemaStore
     */
    public static BinaryMessageDecoder<DateRecord> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<>(MODEL$, SCHEMA$, resolver);
    }

    /**
     * Serializes this DateRecord to a ByteBuffer.
     *
     * @return                     a buffer holding the serialized data for this instance
     * @throws java.io.IOException if this instance could not be serialized
     */
    public java.nio.ByteBuffer toByteBuffer() throws java.io.IOException {
        return ENCODER.encode(this);
    }

    /**
     * Deserializes a DateRecord from a ByteBuffer.
     *
     * @param  b                   a byte buffer holding serialized data for an instance of this class
     * @return                     a DateRecord instance decoded from the given buffer
     * @throws java.io.IOException if the given bytes could not be deserialized into an instance of this class
     */
    public static DateRecord fromByteBuffer(
            java.nio.ByteBuffer b)
            throws java.io.IOException {
        return DECODER.decode(b);
    }

    private java.time.LocalDate date;
    private java.time.Instant timestamp;

    /**
     * Default constructor. Note that this does not initialize fields to their default values from the schema. If that
     * is desired then one should use <code>newBuilder()</code>.
     */
    public DateRecord() {
    }

    /**
     * All-args constructor.
     *
     * @param date      The new value for date
     * @param timestamp The new value for timestamp
     */
    public DateRecord(java.time.LocalDate date, java.time.Instant timestamp) {
        this.date = date;
        this.timestamp = timestamp;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public org.apache.avro.Schema getSchema() {
        return SCHEMA$;
    }

    // Used by DatumWriter.  Applications should not call.
    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0:
                return date;
            case 1:
                return timestamp;
            default:
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
        }
    }

    // Used by DatumReader.  Applications should not call.
    @Override
    @SuppressWarnings(value = "unchecked")
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0:
                date = (java.time.LocalDate) value$;
                break;
            case 1:
                timestamp = (java.time.Instant) value$;
                break;
            default:
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
        }
    }

    /**
     * Gets the value of the 'date' field.
     *
     * @return The value of the 'date' field.
     */
    public java.time.LocalDate getDate() {
        return date;
    }

    /**
     * Sets the value of the 'date' field.
     *
     * @param value the value to set.
     */
    public void setDate(java.time.LocalDate value) {
        this.date = value;
    }

    /**
     * Gets the value of the 'timestamp' field.
     *
     * @return The value of the 'timestamp' field.
     */
    public java.time.Instant getTimestamp() {
        return timestamp;
    }

    /**
     * Sets the value of the 'timestamp' field.
     *
     * @param value the value to set.
     */
    public void setTimestamp(java.time.Instant value) {
        this.timestamp = value;
    }

    /**
     * Creates a new DateRecord RecordBuilder.
     *
     * @return A new DateRecord RecordBuilder
     */
    public static Builder newBuilder() {
        return new Builder();
    }

    /**
     * Creates a new DateRecord RecordBuilder by copying an existing Builder.
     *
     * @param  other The existing builder to copy.
     * @return       A new DateRecord RecordBuilder
     */
    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        } else {
            return new Builder(other);
        }
    }

    /**
     * Creates a new DateRecord RecordBuilder by copying an existing DateRecord instance.
     *
     * @param  other The existing instance to copy.
     * @return       A new DateRecord RecordBuilder
     */
    public static Builder newBuilder(DateRecord other) {
        if (other == null) {
            return new Builder();
        } else {
            return new org.apache.camel.dataformat.avro.example.DateRecord.Builder(other);
        }
    }

    /**
     * RecordBuilder for DateRecord instances.
     */
    @org.apache.avro.specific.AvroGenerated
    public static class Builder extends org.apache.avro.specific.SpecificRecordBuilderBase<DateRecord>
            implements org.apache.avro.data.RecordBuilder<DateRecord> {

        private java.time.LocalDate date;
        private java.time.Instant timestamp;

        /** Creates a new Builder */
        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        /**
         * Creates a Builder by copying an existing Builder.
         *
         * @param other The existing Builder to copy.
         */
        private Builder(org.apache.camel.dataformat.avro.example.DateRecord.Builder other) {
            super(other);
            if (isValidValue(fields()[0], other.date)) {
                this.date = data().deepCopy(fields()[0].schema(), other.date);
                fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (isValidValue(fields()[1], other.timestamp)) {
                this.timestamp = data().deepCopy(fields()[1].schema(), other.timestamp);
                fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
        }

        /**
         * Creates a Builder by copying an existing DateRecord instance
         *
         * @param other The existing instance to copy.
         */
        private Builder(org.apache.camel.dataformat.avro.example.DateRecord other) {
            super(SCHEMA$, MODEL$);
            if (isValidValue(fields()[0], other.date)) {
                this.date = data().deepCopy(fields()[0].schema(), other.date);
                fieldSetFlags()[0] = true;
            }
            if (isValidValue(fields()[1], other.timestamp)) {
                this.timestamp = data().deepCopy(fields()[1].schema(), other.timestamp);
                fieldSetFlags()[1] = true;
            }
        }

        /**
         * Gets the value of the 'date' field.
         *
         * @return The value.
         */
        public java.time.LocalDate getDate() {
            return date;
        }

        /**
         * Sets the value of the 'date' field.
         *
         * @param  value The value of 'date'.
         * @return       This builder.
         */
        public org.apache.camel.dataformat.avro.example.DateRecord.Builder setDate(java.time.LocalDate value) {
            validate(fields()[0], value);
            this.date = value;
            fieldSetFlags()[0] = true;
            return this;
        }

        /**
         * Checks whether the 'date' field has been set.
         *
         * @return True if the 'date' field has been set, false otherwise.
         */
        public boolean hasDate() {
            return fieldSetFlags()[0];
        }

        /**
         * Clears the value of the 'date' field.
         *
         * @return This builder.
         */
        public org.apache.camel.dataformat.avro.example.DateRecord.Builder clearDate() {
            date = null;
            fieldSetFlags()[0] = false;
            return this;
        }

        /**
         * Gets the value of the 'timestamp' field.
         *
         * @return The value.
         */
        public java.time.Instant getTimestamp() {
            return timestamp;
        }

        /**
         * Sets the value of the 'timestamp' field.
         *
         * @param  value The value of 'timestamp'.
         * @return       This builder.
         */
        public org.apache.camel.dataformat.avro.example.DateRecord.Builder setTimestamp(java.time.Instant value) {
            validate(fields()[1], value);
            this.timestamp = value;
            fieldSetFlags()[1] = true;
            return this;
        }

        /**
         * Checks whether the 'timestamp' field has been set.
         *
         * @return True if the 'timestamp' field has been set, false otherwise.
         */
        public boolean hasTimestamp() {
            return fieldSetFlags()[1];
        }

        /**
         * Clears the value of the 'timestamp' field.
         *
         * @return This builder.
         */
        public org.apache.camel.dataformat.avro.example.DateRecord.Builder clearTimestamp() {
            timestamp = null;
            fieldSetFlags()[1] = false;
            return this;
        }

        @Override
        @SuppressWarnings("unchecked")
        public DateRecord build() {
            try {
                DateRecord record = new DateRecord();
                record.date = fieldSetFlags()[0] ? this.date : (java.time.LocalDate) defaultValue(fields()[0]);
                record.timestamp = fieldSetFlags()[1] ? this.timestamp : (java.time.Instant) defaultValue(fields()[1]);
                return record;
            } catch (org.apache.avro.AvroMissingFieldException e) {
                throw e;
            } catch (java.lang.Exception e) {
                throw new org.apache.avro.AvroRuntimeException(e);
            }
        }
    }

    @SuppressWarnings("unchecked")
    private static final org.apache.avro.io.DatumWriter<DateRecord> WRITER$
            = (org.apache.avro.io.DatumWriter<DateRecord>) MODEL$.createDatumWriter(SCHEMA$);

    @Override
    public void writeExternal(java.io.ObjectOutput out)
            throws java.io.IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @SuppressWarnings("unchecked")
    private static final org.apache.avro.io.DatumReader<DateRecord> READER$
            = (org.apache.avro.io.DatumReader<DateRecord>) MODEL$.createDatumReader(SCHEMA$);

    @Override
    public void readExternal(java.io.ObjectInput in)
            throws java.io.IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (date == null ? 0 : date.hashCode());
        result = 31 * result + (timestamp == null ? 0 : timestamp.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateRecord)) {
            return false;
        }
        DateRecord other = (DateRecord) o;
        if (!java.util.Objects.equals(this.date, other.date)) {
            return false;
        }
        if (!java.util.Objects.equals(this.timestamp, other.timestamp)) {
            return false;
        }
        return true;
    }
}
