/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractTestConfigurationEvents {
    static final String TEST_PROPNAME = "event.test";
    static final String TEST_PROPVALUE = "a value";
    static final String EXIST_PROPERTY = "event.property";
    protected AbstractConfiguration config;
    protected EventListenerTestImpl listener;

    protected abstract AbstractConfiguration createConfiguration();

    @BeforeEach
    public void setUp() throws Exception {
        this.config = this.createConfiguration();
        this.config.addProperty(EXIST_PROPERTY, (Object)"existing value");
        this.listener = new EventListenerTestImpl(this.config);
        this.config.addEventListener(ConfigurationEvent.ANY, (EventListener)this.listener);
    }

    @Test
    void testAddPropertyEvent() {
        this.config.addProperty(TEST_PROPNAME, (Object)TEST_PROPVALUE);
        this.listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, TEST_PROPNAME, TEST_PROPVALUE, true);
        this.listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, TEST_PROPNAME, TEST_PROPVALUE, false);
        this.listener.done();
    }

    @Test
    void testAddPropertyEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.addProperty(TEST_PROPNAME, (Object)TEST_PROPVALUE);
        this.listener.checkEventCount(2);
        this.listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, TEST_PROPNAME, TEST_PROPVALUE, true);
        this.listener.skipToLast(ConfigurationEvent.ADD_PROPERTY);
        this.listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, TEST_PROPNAME, TEST_PROPVALUE, false);
        this.listener.done();
    }

    @Test
    void testClearEvent() {
        this.config.clear();
        this.listener.checkEvent(ConfigurationEvent.CLEAR, null, null, true);
        this.listener.checkEvent(ConfigurationEvent.CLEAR, null, null, false);
        this.listener.done();
    }

    @Test
    void testClearEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.clear();
        this.listener.checkEventCount(2);
        this.listener.checkEvent(ConfigurationEvent.CLEAR, null, null, true);
        this.listener.skipToLast(ConfigurationEvent.CLEAR);
        this.listener.checkEvent(ConfigurationEvent.CLEAR, null, null, false);
        this.listener.done();
    }

    @Test
    void testClearPropertyEvent() {
        this.config.clearProperty(EXIST_PROPERTY);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, EXIST_PROPERTY, null, true);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, EXIST_PROPERTY, null, false);
        this.listener.done();
    }

    @Test
    void testClearPropertyEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.clearProperty(EXIST_PROPERTY);
        this.listener.checkEventCount(2);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, EXIST_PROPERTY, null, true);
        this.listener.skipToLast(ConfigurationEvent.CLEAR_PROPERTY);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, EXIST_PROPERTY, null, false);
        this.listener.done();
    }

    @Test
    void testSetPropertyEvent() {
        this.config.setProperty(EXIST_PROPERTY, (Object)TEST_PROPVALUE);
        this.listener.checkEvent(ConfigurationEvent.SET_PROPERTY, EXIST_PROPERTY, TEST_PROPVALUE, true);
        this.listener.checkEvent(ConfigurationEvent.SET_PROPERTY, EXIST_PROPERTY, TEST_PROPVALUE, false);
        this.listener.done();
    }

    @Test
    void testSetPropertyEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.setProperty(EXIST_PROPERTY, (Object)TEST_PROPVALUE);
        this.listener.checkEventCount(2);
        this.listener.checkEvent(ConfigurationEvent.SET_PROPERTY, EXIST_PROPERTY, TEST_PROPVALUE, true);
        this.listener.skipToLast(ConfigurationEvent.SET_PROPERTY);
        this.listener.checkEvent(ConfigurationEvent.SET_PROPERTY, EXIST_PROPERTY, TEST_PROPVALUE, false);
        this.listener.done();
    }
}

