/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;

public final class ResourceNames {
    public static final String BROKER = "broker";
    public static final String MANAGEMENT_SECURITY = "managementsecurity";
    public static final String QUEUE = "queue.";
    public static final String ADDRESS = "address.";
    public static final String BROKER_CONNECTION = "brokerconnection.";
    public static final String REMOTE_BROKER_CONNECTION = "remotebrokerconnection.";
    public static final String BRIDGE = "bridge.";
    public static final String ACCEPTOR = "acceptor.";
    public static final String DIVERT = "divert.";
    public static final String CORE_CLUSTER_CONNECTION = "clusterconnection.";
    public static final String BROADCAST_GROUP = "broadcastgroup.";
    public static final String CONNECTION_ROUTER = "connectionrouter.";
    public static final String RETROACTIVE_SUFFIX = "retro";

    public static SimpleString getRetroactiveResourceQueueName(String prefix, String delimiter, SimpleString address, RoutingType routingType) {
        return ResourceNames.getRetroactiveResourceName(prefix, delimiter, address, ResourceNames.trimLastCharacter(QUEUE).concat(delimiter).concat(routingType.toString().toLowerCase()));
    }

    public static SimpleString getRetroactiveResourceAddressName(String prefix, String delimiter, SimpleString address) {
        return ResourceNames.getRetroactiveResourceName(prefix, delimiter, address, ResourceNames.trimLastCharacter(ADDRESS));
    }

    public static SimpleString getRetroactiveResourceDivertName(String prefix, String delimiter, SimpleString address) {
        return ResourceNames.getRetroactiveResourceName(prefix, delimiter, address, ResourceNames.trimLastCharacter(DIVERT));
    }

    private static SimpleString getRetroactiveResourceName(String prefix, String delimiter, SimpleString address, String resourceType) {
        return SimpleString.of((String)prefix.concat(address.toString()).concat(delimiter).concat(resourceType).concat(delimiter).concat(RETROACTIVE_SUFFIX));
    }

    public static boolean isRetroactiveResource(String prefix, SimpleString address) {
        return address.toString().startsWith(prefix) && address.toString().endsWith(RETROACTIVE_SUFFIX);
    }

    public static String decomposeRetroactiveResourceAddressName(String prefix, String delimiter, String address) {
        return address.substring(prefix.length(), address.length() - (delimiter.length() + ADDRESS.length() + RETROACTIVE_SUFFIX.length()));
    }

    private static String trimLastCharacter(String toTrim) {
        return toTrim.substring(0, toTrim.length() - 1);
    }
}

