/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.reflect;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.reflect.InstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class ReflectionUtils {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new HashMap();
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    private static void registerPrimitiveClassPair(Class<?> left, Class<?> right) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(left, right);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(right, left);
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static boolean isAssignableFrom(Class<?> leftType, Class<?> rightType) {
        boolean result;
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        if (leftType == Object.class) {
            return true;
        }
        if (leftType == rightType) {
            return true;
        }
        Class<?> r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        boolean bl = result = r == rightType;
        if (!result) {
            if (rightType.isPrimitive()) {
                r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(rightType);
                if (r != null) {
                    result = leftType.isAssignableFrom(r);
                }
            } else {
                result = leftType.isAssignableFrom(rightType);
            }
        }
        return result;
    }

    public static <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getConstructor(EMPTY_CLASS_ARRAY).newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.getClass().getName() + " error creating instance of class [" + e.getMessage() + "]: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException(e.getClass().getName() + " error creating instance of class [" + e.getMessage() + "]: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException(e.getClass().getName() + " error creating instance of class [" + e.getMessage() + "]: " + e.getMessage(), e);
        }
        catch (java.lang.InstantiationException e) {
            throw new InstantiationException(e.getClass().getName() + " error creating instance of class [" + e.getMessage() + "]: " + e.getMessage(), e);
        }
    }

    public static PropertyDescriptor[] getPropertiesOfType(Class<?> clazz, Class<?> propertyType) {
        if (clazz == null || propertyType == null) {
            return new PropertyDescriptor[0];
        }
        LinkedHashSet<PropertyDescriptor> properties = new LinkedHashSet<PropertyDescriptor>();
        try {
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(clazz)) {
                Class<?> currentPropertyType = descriptor.getPropertyType();
                if (!ReflectionUtils.isTypeInstanceOfPropertyType(propertyType, currentPropertyType)) continue;
                properties.add(descriptor);
            }
        }
        catch (Exception e) {
            return new PropertyDescriptor[0];
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    private static boolean isTypeInstanceOfPropertyType(Class<?> type, Class<?> propertyType) {
        return propertyType.isAssignableFrom(type) && !propertyType.equals(Object.class);
    }

    public static boolean isGetter(String name, Class<?>[] args) {
        if (!StringUtils.hasText(name) || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith("get") ? (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0)) : name.startsWith("is") && (name = name.substring(2)).length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    public static boolean isSetter(String name, Class[] args) {
        if (!StringUtils.hasText(name) || args == null) {
            return false;
        }
        if (name.startsWith("set")) {
            if (args.length != 1) {
                return false;
            }
            if ((name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    public static Class forName(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new DatastoreConfigurationException("Class not found loading GORM: " + e.getMessage(), e);
        }
    }

    static {
        ReflectionUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        ReflectionUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        ReflectionUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        ReflectionUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        ReflectionUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        ReflectionUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        ReflectionUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        ReflectionUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
    }
}

