/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.sql.SQLException;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.BehaviorChangeConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.AtomicOperationMetaStoreManager;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PrincipalSecretsGenerator;
import org.apache.polaris.core.persistence.bootstrap.BootstrapOptions;
import org.apache.polaris.core.persistence.bootstrap.ImmutableBootstrapOptions;
import org.apache.polaris.core.persistence.bootstrap.ImmutableSchemaOptions;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.bootstrap.SchemaOptions;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.cache.InMemoryEntityCache;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.persistence.relational.jdbc.DatasourceOperations;
import org.apache.polaris.persistence.relational.jdbc.JdbcBasePersistenceImpl;
import org.apache.polaris.persistence.relational.jdbc.JdbcBootstrapUtils;
import org.apache.polaris.persistence.relational.jdbc.RelationalJdbcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="relational-jdbc")
public class JdbcMetaStoreManagerFactory
implements MetaStoreManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcMetaStoreManagerFactory.class);
    final Map<String, PolarisMetaStoreManager> metaStoreManagerMap = new HashMap<String, PolarisMetaStoreManager>();
    final Map<String, EntityCache> entityCacheMap = new HashMap<String, EntityCache>();
    final Map<String, Supplier<BasePersistence>> sessionSupplierMap = new HashMap<String, Supplier<BasePersistence>>();
    @Inject
    Clock clock;
    @Inject
    PolarisDiagnostics diagnostics;
    @Inject
    PolarisStorageIntegrationProvider storageIntegrationProvider;
    @Inject
    Instance<DataSource> dataSource;
    @Inject
    RelationalJdbcConfiguration relationalJdbcConfiguration;
    @Inject
    PolarisConfigurationStore configurationStore;

    protected JdbcMetaStoreManagerFactory() {
    }

    protected PrincipalSecretsGenerator secretsGenerator(String realmId, @Nullable RootCredentialsSet rootCredentialsSet) {
        if (rootCredentialsSet != null) {
            return PrincipalSecretsGenerator.bootstrap((String)realmId, (RootCredentialsSet)rootCredentialsSet);
        }
        return PrincipalSecretsGenerator.RANDOM_SECRETS;
    }

    protected PolarisMetaStoreManager createNewMetaStoreManager() {
        return new AtomicOperationMetaStoreManager(this.clock, this.diagnostics);
    }

    private void initializeForRealm(DatasourceOperations datasourceOperations, RealmContext realmContext, RootCredentialsSet rootCredentialsSet) {
        String realmId = realmContext.getRealmIdentifier();
        int schemaVersion = JdbcBasePersistenceImpl.loadSchemaVersion(datasourceOperations, (Boolean)this.configurationStore.getConfiguration(realmContext, (PolarisConfiguration)BehaviorChangeConfiguration.SCHEMA_VERSION_FALL_BACK_ON_DNE));
        this.sessionSupplierMap.put(realmId, () -> new JdbcBasePersistenceImpl(this.diagnostics, datasourceOperations, this.secretsGenerator(realmId, rootCredentialsSet), this.storageIntegrationProvider, realmId, schemaVersion));
        PolarisMetaStoreManager metaStoreManager = this.createNewMetaStoreManager();
        this.metaStoreManagerMap.put(realmId, metaStoreManager);
    }

    public DatasourceOperations getDatasourceOperations() {
        DatasourceOperations databaseOperations;
        try {
            databaseOperations = new DatasourceOperations((DataSource)this.dataSource.get(), this.relationalJdbcConfiguration);
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
        return databaseOperations;
    }

    public synchronized Map<String, PrincipalSecretsResult> bootstrapRealms(Iterable<String> realms, RootCredentialsSet rootCredentialsSet) {
        ImmutableSchemaOptions schemaOptions = ImmutableSchemaOptions.builder().build();
        ImmutableBootstrapOptions bootstrapOptions = ImmutableBootstrapOptions.builder().realms(realms).rootCredentialsSet(rootCredentialsSet).schemaOptions((SchemaOptions)schemaOptions).build();
        return this.bootstrapRealms((BootstrapOptions)bootstrapOptions);
    }

    public synchronized Map<String, PrincipalSecretsResult> bootstrapRealms(BootstrapOptions bootstrapOptions) {
        HashMap<String, PrincipalSecretsResult> results = new HashMap<String, PrincipalSecretsResult>();
        for (String realm : bootstrapOptions.realms()) {
            RealmContext realmContext = () -> realm;
            if (this.metaStoreManagerMap.containsKey(realm)) continue;
            DatasourceOperations datasourceOperations = this.getDatasourceOperations();
            int currentSchemaVersion = JdbcBasePersistenceImpl.loadSchemaVersion(datasourceOperations, (Boolean)this.configurationStore.getConfiguration(realmContext, (PolarisConfiguration)BehaviorChangeConfiguration.SCHEMA_VERSION_FALL_BACK_ON_DNE));
            int requestedSchemaVersion = JdbcBootstrapUtils.getRequestedSchemaVersion(bootstrapOptions);
            int effectiveSchemaVersion = JdbcBootstrapUtils.getRealmBootstrapSchemaVersion(currentSchemaVersion, requestedSchemaVersion, JdbcBasePersistenceImpl.entityTableExists(datasourceOperations));
            LOGGER.info("Effective schema version: {} for bootstrapping realm: {}", (Object)effectiveSchemaVersion, (Object)realm);
            try {
                datasourceOperations.executeScript(datasourceOperations.getDatabaseType().openInitScriptResource(effectiveSchemaVersion));
            }
            catch (SQLException e) {
                throw new RuntimeException(String.format("Error executing sql script: %s", e.getMessage()), e);
            }
            this.initializeForRealm(datasourceOperations, realmContext, bootstrapOptions.rootCredentialsSet());
            PrincipalSecretsResult secretsResult = this.bootstrapServiceAndCreatePolarisPrincipalForRealm(realmContext);
            results.put(realm, secretsResult);
        }
        return Map.copyOf(results);
    }

    public Map<String, BaseResult> purgeRealms(Iterable<String> realms) {
        HashMap<String, BaseResult> results = new HashMap<String, BaseResult>();
        for (String realm : realms) {
            RealmContext realmContext = () -> realm;
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            BasePersistence session = this.getOrCreateSession(realmContext);
            PolarisCallContext callContext = new PolarisCallContext(realmContext, session);
            BaseResult result = metaStoreManager.purge(callContext);
            results.put(realm, result);
            this.sessionSupplierMap.remove(realm);
            this.metaStoreManagerMap.remove(realm);
        }
        return Map.copyOf(results);
    }

    public synchronized PolarisMetaStoreManager getOrCreateMetaStoreManager(RealmContext realmContext) {
        if (!this.metaStoreManagerMap.containsKey(realmContext.getRealmIdentifier())) {
            DatasourceOperations datasourceOperations = this.getDatasourceOperations();
            this.initializeForRealm(datasourceOperations, realmContext, null);
            this.checkPolarisServiceBootstrappedForRealm(realmContext);
        }
        return this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
    }

    public synchronized BasePersistence getOrCreateSession(RealmContext realmContext) {
        if (!this.sessionSupplierMap.containsKey(realmContext.getRealmIdentifier())) {
            DatasourceOperations datasourceOperations = this.getDatasourceOperations();
            this.initializeForRealm(datasourceOperations, realmContext, null);
        }
        this.checkPolarisServiceBootstrappedForRealm(realmContext);
        return this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get();
    }

    public synchronized EntityCache getOrCreateEntityCache(RealmContext realmContext, RealmConfig realmConfig) {
        if (!this.entityCacheMap.containsKey(realmContext.getRealmIdentifier())) {
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            this.entityCacheMap.put(realmContext.getRealmIdentifier(), (EntityCache)new InMemoryEntityCache(this.diagnostics, realmConfig, metaStoreManager));
        }
        return this.entityCacheMap.get(realmContext.getRealmIdentifier());
    }

    private PrincipalSecretsResult bootstrapServiceAndCreatePolarisPrincipalForRealm(RealmContext realmContext) {
        BasePersistence metaStore;
        PolarisCallContext polarisContext;
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
        Optional preliminaryRootPrincipal = metaStoreManager.findRootPrincipal(polarisContext = new PolarisCallContext(realmContext, metaStore = this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get()));
        if (preliminaryRootPrincipal.isPresent()) {
            String overrideMessage = "It appears this metastore manager has already been bootstrapped. To continue bootstrapping, please first purge the metastore with the `purge` command.";
            LOGGER.error("\n\n {} \n\n", (Object)overrideMessage);
            throw new IllegalArgumentException(overrideMessage);
        }
        metaStoreManager.bootstrapPolarisService(polarisContext);
        PrincipalEntity rootPrincipal = (PrincipalEntity)metaStoreManager.findRootPrincipal(polarisContext).orElseThrow();
        return metaStoreManager.loadPrincipalSecrets(polarisContext, rootPrincipal.getClientId());
    }

    private void checkPolarisServiceBootstrappedForRealm(RealmContext realmContext) {
        BasePersistence metaStore;
        PolarisCallContext polarisContext;
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
        Optional rootPrincipal = metaStoreManager.findRootPrincipal(polarisContext = new PolarisCallContext(realmContext, metaStore = this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get()));
        if (rootPrincipal.isEmpty()) {
            LOGGER.error("\n\n Realm {} is not bootstrapped, could not load root principal. Please run Bootstrap command. \n\n", (Object)realmContext.getRealmIdentifier());
            throw new IllegalStateException("Realm is not bootstrapped, please run server in bootstrap mode.");
        }
    }
}

