/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum OpenFileMode implements UaEnumeration
{
    Read(1),
    Write(2),
    EraseExisting(4),
    Append(8);

    private final int value;

    private OpenFileMode(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static OpenFileMode from(int value) {
        switch (value) {
            case 1: {
                return Read;
            }
            case 2: {
                return Write;
            }
            case 4: {
                return EraseExisting;
            }
            case 8: {
                return Append;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11939");
    }

    public static class Codec
    extends GenericDataTypeCodec<OpenFileMode> {
        @Override
        public Class<OpenFileMode> getType() {
            return OpenFileMode.class;
        }

        @Override
        public OpenFileMode decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, OpenFileMode.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, OpenFileMode value) {
            encoder.writeEnum(null, value);
        }
    }
}

