/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.batch;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.batch.PipeTabletEventBatch;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletBatchReqV2;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeTabletEventPlainBatch
extends PipeTabletEventBatch {
    private final List<ByteBuffer> binaryBuffers = new ArrayList<ByteBuffer>();
    private final List<ByteBuffer> insertNodeBuffers = new ArrayList<ByteBuffer>();
    private final List<ByteBuffer> tabletBuffers = new ArrayList<ByteBuffer>();
    private static final String TREE_MODEL_DATABASE_PLACEHOLDER = null;
    private final List<String> binaryDataBases = new ArrayList<String>();
    private final List<String> insertNodeDataBases = new ArrayList<String>();
    private final List<String> tabletDataBases = new ArrayList<String>();
    private final Map<String, Map<String, Pair<Integer, List<Tablet>>>> tableModelTabletMap = new HashMap<String, Map<String, Pair<Integer, List<Tablet>>>>();
    private final Map<Pair<String, Long>, Long> pipe2BytesAccumulated = new HashMap<Pair<String, Long>, Long>();

    PipeTabletEventPlainBatch(int maxDelayInMs, long requestMaxBatchSizeInBytes, PipeTabletEventBatch.TriLongConsumer recordMetric) {
        super(maxDelayInMs, requestMaxBatchSizeInBytes, recordMetric);
    }

    @Override
    protected boolean constructBatch(TabletInsertionEvent event) throws IOException {
        long bufferSize = this.buildTabletInsertionBuffer(event);
        this.totalBufferSize += bufferSize;
        this.pipe2BytesAccumulated.compute((Pair<String, Long>)new Pair((Object)((EnrichedEvent)event).getPipeName(), (Object)((EnrichedEvent)event).getCreationTime()), (pipeName, bytesAccumulated) -> bytesAccumulated == null ? bufferSize : bytesAccumulated + bufferSize);
        return true;
    }

    @Override
    public synchronized void onSuccess() {
        super.onSuccess();
        this.binaryBuffers.clear();
        this.insertNodeBuffers.clear();
        this.tabletBuffers.clear();
        this.binaryDataBases.clear();
        this.insertNodeDataBases.clear();
        this.tabletDataBases.clear();
        this.tableModelTabletMap.clear();
        this.pipe2BytesAccumulated.clear();
    }

    public PipeTransferTabletBatchReqV2 toTPipeTransferReq() throws IOException {
        for (Map.Entry<String, Map<String, Pair<Integer, List<Tablet>>>> insertTablets : this.tableModelTabletMap.entrySet()) {
            String databaseName = insertTablets.getKey();
            for (Map.Entry<String, Pair<Integer, List<Tablet>>> tabletEntry : insertTablets.getValue().entrySet()) {
                ArrayList<Pair> batchTablets = new ArrayList<Pair>();
                for (Tablet tablet : (List)tabletEntry.getValue().getRight()) {
                    boolean success = false;
                    for (Pair tabletPair : batchTablets) {
                        if (((Boolean)tabletPair.getLeft()).booleanValue()) {
                            tabletPair.setRight((Object)PipeTabletEventPlainBatch.copyTablet((Tablet)tabletPair.getRight()));
                            tabletPair.setLeft((Object)Boolean.FALSE);
                        }
                        if (!((Tablet)tabletPair.getRight()).append(tablet, ((Integer)tabletEntry.getValue().getLeft()).intValue())) continue;
                        success = true;
                        break;
                    }
                    if (success) continue;
                    batchTablets.add(new Pair((Object)Boolean.TRUE, (Object)tablet));
                }
                for (Pair tabletPair : batchTablets) {
                    try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
                         DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                        ((Tablet)tabletPair.getRight()).serialize(outputStream);
                        ReadWriteIOUtils.write((Boolean)true, (OutputStream)outputStream);
                        this.tabletBuffers.add(ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size()));
                    }
                    this.tabletDataBases.add(databaseName);
                }
            }
        }
        this.tableModelTabletMap.clear();
        return PipeTransferTabletBatchReqV2.toTPipeTransferReq(this.binaryBuffers, this.insertNodeBuffers, this.tabletBuffers, this.binaryDataBases, this.insertNodeDataBases, this.tabletDataBases);
    }

    public Map<Pair<String, Long>, Long> deepCopyPipeName2BytesAccumulated() {
        return new HashMap<Pair<String, Long>, Long>(this.pipe2BytesAccumulated);
    }

    public Map<Pair<String, Long>, Long> getPipe2BytesAccumulated() {
        return this.pipe2BytesAccumulated;
    }

    private long buildTabletInsertionBuffer(TabletInsertionEvent event) throws IOException {
        long estimateSize = 0L;
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNode();
            if (!(insertNode instanceof RelationalInsertTabletNode)) {
                ByteBuffer buffer = insertNode.serializeToByteBuffer();
                this.insertNodeBuffers.add(buffer);
                if (pipeInsertNodeTabletInsertionEvent.isTableModelEvent()) {
                    estimateSize = RamUsageEstimator.sizeOf((String)pipeInsertNodeTabletInsertionEvent.getTableModelDatabaseName());
                    this.insertNodeDataBases.add(pipeInsertNodeTabletInsertionEvent.getTableModelDatabaseName());
                } else {
                    estimateSize = 4L;
                    this.insertNodeDataBases.add(TREE_MODEL_DATABASE_PLACEHOLDER);
                }
                estimateSize += (long)buffer.limit();
            } else {
                for (Tablet tablet : ((PipeInsertNodeTabletInsertionEvent)event).convertToTablets()) {
                    estimateSize += this.constructTabletBatch(tablet, pipeInsertNodeTabletInsertionEvent.getTableModelDatabaseName());
                }
            }
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event;
            if (pipeRawTabletInsertionEvent.isTableModelEvent()) {
                estimateSize = this.constructTabletBatch(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.getTableModelDatabaseName());
            } else {
                ByteBuffer buffer;
                try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
                     DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                    pipeRawTabletInsertionEvent.convertToTablet().serialize(outputStream);
                    ReadWriteIOUtils.write((Boolean)pipeRawTabletInsertionEvent.isAligned(), (OutputStream)outputStream);
                    buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
                }
                estimateSize = 4 + buffer.limit();
                this.tabletBuffers.add(buffer);
                this.tabletDataBases.add(TREE_MODEL_DATABASE_PLACEHOLDER);
            }
        }
        return estimateSize;
    }

    private long constructTabletBatch(Tablet tablet, String databaseName) {
        AtomicLong size = new AtomicLong(0L);
        Pair currentBatch = this.tableModelTabletMap.computeIfAbsent(databaseName, k -> {
            size.addAndGet(RamUsageEstimator.sizeOf((String)databaseName));
            return new HashMap();
        }).computeIfAbsent(tablet.getTableName(), k -> new Pair((Object)0, new ArrayList()));
        currentBatch.setLeft((Object)((Integer)currentBatch.getLeft() + tablet.getRowSize()));
        ((List)currentBatch.getRight()).add(tablet);
        return PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet) + 4L;
    }

    public static Tablet copyTablet(Tablet tablet) {
        Object[] copiedValues = new Object[tablet.getValues().length];
        for (int i = 0; i < tablet.getValues().length; ++i) {
            if (tablet.getValues()[i] == null || tablet.getSchemas() == null || tablet.getSchemas().get(i) == null) continue;
            copiedValues[i] = PipeTabletEventPlainBatch.copyValueList(tablet.getValues()[i], ((IMeasurementSchema)tablet.getSchemas().get(i)).getType(), tablet.getRowSize());
        }
        BitMap[] bitMaps = null;
        if (tablet.getBitMaps() != null) {
            bitMaps = (BitMap[])Arrays.stream(tablet.getBitMaps()).map(bitMap -> {
                if (bitMap != null) {
                    byte[] data = bitMap.getByteArray();
                    return new BitMap(bitMap.getSize(), Arrays.copyOf(data, data.length));
                }
                return null;
            }).toArray(BitMap[]::new);
        }
        return new Tablet(tablet.getTableName(), new ArrayList(tablet.getSchemas()), new ArrayList(tablet.getColumnTypes()), Arrays.copyOf(tablet.getTimestamps(), tablet.getRowSize()), copiedValues, bitMaps, tablet.getRowSize());
    }

    private static Object copyValueList(Object valueList, TSDataType dataType, int rowSize) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] copiedBoolValues = new boolean[rowSize];
                System.arraycopy(boolValues, 0, copiedBoolValues, 0, rowSize);
                return copiedBoolValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] copiedIntValues = new int[rowSize];
                System.arraycopy(intValues, 0, copiedIntValues, 0, rowSize);
                return copiedIntValues;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])valueList;
                LocalDate[] copiedDateValues = new LocalDate[rowSize];
                System.arraycopy(dateValues, 0, copiedDateValues, 0, rowSize);
                return copiedDateValues;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])valueList;
                long[] copiedLongValues = new long[rowSize];
                System.arraycopy(longValues, 0, copiedLongValues, 0, rowSize);
                return copiedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] copiedFloatValues = new float[rowSize];
                System.arraycopy(floatValues, 0, copiedFloatValues, 0, rowSize);
                return copiedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] copiedDoubleValues = new double[rowSize];
                System.arraycopy(doubleValues, 0, copiedDoubleValues, 0, rowSize);
                return copiedDoubleValues;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] copiedBinaryValues = new Binary[rowSize];
                System.arraycopy(binaryValues, 0, copiedBinaryValues, 0, rowSize);
                return copiedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
    }
}

