/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class Utils {
    public static final String UNSUPPORTED_TYPE_MESSAGE = "Unsupported data type : %s";

    private Utils() {
    }

    public static void serializeValue(TSDataType dataType, TsPrimitiveType value, byte[] valueBytes, int offset) {
        switch (dataType) {
            case INT32: 
            case DATE: {
                BytesUtils.intToBytes((int)value.getInt(), (byte[])valueBytes, (int)offset);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                BytesUtils.longToBytes((long)value.getLong(), (byte[])valueBytes, (int)offset);
                break;
            }
            case FLOAT: {
                BytesUtils.floatToBytes((float)value.getFloat(), (byte[])valueBytes, (int)offset);
                break;
            }
            case DOUBLE: {
                BytesUtils.doubleToBytes((double)value.getDouble(), (byte[])valueBytes, (int)offset);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                BytesUtils.intToBytes((int)value.getBinary().getValues().length, (byte[])valueBytes, (int)offset);
                System.arraycopy(value.getBinary().getValues(), 0, valueBytes, offset += 4, value.getBinary().getValues().length);
                break;
            }
            case BOOLEAN: {
                BytesUtils.boolToBytes((boolean)value.getBoolean(), (byte[])valueBytes, (int)offset);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, dataType));
            }
        }
    }

    public static void serializeBinaryValue(Binary binary, byte[] valueBytes, int offset) {
        BytesUtils.intToBytes((int)binary.getValues().length, (byte[])valueBytes, (int)offset);
        System.arraycopy(binary.getValues(), 0, valueBytes, offset += 4, binary.getValues().length);
    }

    public static byte[] serializeTimeValue(TSDataType seriesDataType, long time, TsPrimitiveType value) {
        byte[] valueBytes = new byte[8 + Utils.calcTypeSize(seriesDataType, value)];
        BytesUtils.longToBytes((long)time, (byte[])valueBytes, (int)0);
        Utils.serializeValue(seriesDataType, value, valueBytes, 8);
        return valueBytes;
    }

    public static byte[] serializeTimeValue(TSDataType seriesDataType, long time, boolean valueIsNull, TsPrimitiveType value) {
        if (valueIsNull) {
            byte[] valueBytes = new byte[9];
            BytesUtils.longToBytes((long)time, (byte[])valueBytes, (int)0);
            BytesUtils.boolToBytes((boolean)true, (byte[])valueBytes, (int)8);
            return valueBytes;
        }
        byte[] valueBytes = new byte[9 + Utils.calcTypeSize(seriesDataType, value)];
        BytesUtils.longToBytes((long)time, (byte[])valueBytes, (int)0);
        BytesUtils.boolToBytes((boolean)false, (byte[])valueBytes, (int)8);
        Utils.serializeValue(seriesDataType, value, valueBytes, 9);
        return valueBytes;
    }

    public static int calcTypeSize(TSDataType dataType, TsPrimitiveType value) {
        switch (dataType) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: 
            case DATE: 
            case FLOAT: {
                return 4;
            }
            case INT64: 
            case TIMESTAMP: 
            case DOUBLE: {
                return 8;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return 4 + value.getBinary().getValues().length;
            }
        }
        throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, dataType));
    }

    public static boolean isBinaryType(TSDataType dataType) {
        return TSDataType.TEXT == dataType || TSDataType.BLOB == dataType || TSDataType.STRING == dataType;
    }
}

