/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.Iterables;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SemiJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class TransformUncorrelatedInPredicateSubqueryToSemiJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().with(Pattern.empty(Patterns.Apply.correlation()));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        if (applyNode.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        ApplyNode.SetExpression expression = (ApplyNode.SetExpression)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().values());
        if (!(expression instanceof ApplyNode.In)) {
            return Rule.Result.empty();
        }
        ApplyNode.In inPredicate = (ApplyNode.In)expression;
        Symbol semiJoinSymbol = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().keySet());
        SemiJoinNode replacement = new SemiJoinNode(context.getIdAllocator().genPlanNodeId(), applyNode.getInput(), applyNode.getSubquery(), inPredicate.getValue(), inPredicate.getReference(), semiJoinSymbol);
        return Rule.Result.ofPlanNode(replacement);
    }
}

