/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling.tumbling;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.processor.downsampling.DownSamplingProcessor;
import org.apache.iotdb.db.pipe.processor.downsampling.PartialPathLastObjectCache;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
public class TumblingTimeSamplingProcessor
extends DownSamplingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TumblingTimeSamplingProcessor.class);
    private long intervalInCurrentPrecision;
    private PartialPathLastObjectCache<Long> pathLastObjectCache;

    @Override
    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        long intervalSeconds = validator.getParameters().getLongOrDefault("processor.tumbling-time.interval-seconds", 60L);
        validator.validate(seconds -> (Long)seconds > 0L, String.format("The value of %s must be greater than 0, but got %d.", "processor.tumbling-time.interval-seconds", intervalSeconds), (Object)intervalSeconds);
        this.intervalInCurrentPrecision = TimestampPrecisionUtils.convertToCurrPrecision(intervalSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) {
        super.customize(parameters, configuration);
        LOGGER.info("TumblingTimeSamplingProcessor in {} is initialized with {}: {}s, {}: {}, {}: {}.", new Object[]{this.dataBaseNameWithPathSeparator, "processor.tumbling-time.interval-seconds", this.intervalInCurrentPrecision, "processor.down-sampling.memory-limit-in-bytes", this.memoryLimitInBytes, "processor.down-sampling.split-file", this.shouldSplitFile});
    }

    @Override
    protected PartialPathLastObjectCache<?> initPathLastObjectCache(long memoryLimitInBytes) {
        this.pathLastObjectCache = new PartialPathLastObjectCache<Long>(memoryLimitInBytes){

            @Override
            protected long calculateMemoryUsage(Long object) {
                return 8L;
            }
        };
        return this.pathLastObjectCache;
    }

    @Override
    protected void processRow(Row row, RowCollector rowCollector, String deviceSuffix, AtomicReference<Exception> exception) {
        int size = row.size();
        for (int index = 0; index < size; ++index) {
            if (row.isNull(index)) continue;
            String timeSeriesSuffix = deviceSuffix + "." + row.getColumnName(index);
            long currentRowTime = row.getTime();
            Long lastSampleTime = this.pathLastObjectCache.getPartialPathLastObject(timeSeriesSuffix);
            if (lastSampleTime != null && Math.abs(currentRowTime - lastSampleTime) < this.intervalInCurrentPrecision) continue;
            try {
                rowCollector.collectRow(row);
                this.pathLastObjectCache.setPartialPathLastObject(timeSeriesSuffix, currentRowTime);
                for (int j = index + 1; j < size; ++j) {
                    if (row.isNull(j)) continue;
                    this.pathLastObjectCache.setPartialPathLastObject(deviceSuffix + "." + row.getColumnName(j), currentRowTime);
                }
                return;
            }
            catch (Exception e) {
                exception.set(e);
            }
        }
    }
}

