/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ComplexNumberType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12171");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12173");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12181");
    private final Float real;
    private final Float imaginary;

    public ComplexNumberType(Float real, Float imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Float getReal() {
        return this.real;
    }

    public Float getImaginary() {
        return this.imaginary;
    }

    protected ComplexNumberType(ComplexNumberTypeBuilder<?, ?> b) {
        super(b);
        this.real = ((ComplexNumberTypeBuilder)b).real;
        this.imaginary = ((ComplexNumberTypeBuilder)b).imaginary;
    }

    public static ComplexNumberTypeBuilder<?, ?> builder() {
        return new ComplexNumberTypeBuilderImpl();
    }

    public ComplexNumberTypeBuilder<?, ?> toBuilder() {
        return new ComplexNumberTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComplexNumberType)) {
            return false;
        }
        ComplexNumberType other = (ComplexNumberType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$real = this.getReal();
        Float other$real = other.getReal();
        if (this$real == null ? other$real != null : !((Object)this$real).equals(other$real)) {
            return false;
        }
        Float this$imaginary = this.getImaginary();
        Float other$imaginary = other.getImaginary();
        return !(this$imaginary == null ? other$imaginary != null : !((Object)this$imaginary).equals(other$imaginary));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComplexNumberType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $real = this.getReal();
        result = result * 59 + ($real == null ? 43 : ((Object)$real).hashCode());
        Float $imaginary = this.getImaginary();
        result = result * 59 + ($imaginary == null ? 43 : ((Object)$imaginary).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ComplexNumberType(real=" + this.getReal() + ", imaginary=" + this.getImaginary() + ")";
    }

    private static final class ComplexNumberTypeBuilderImpl
    extends ComplexNumberTypeBuilder<ComplexNumberType, ComplexNumberTypeBuilderImpl> {
        private ComplexNumberTypeBuilderImpl() {
        }

        @Override
        protected ComplexNumberTypeBuilderImpl self() {
            return this;
        }

        @Override
        public ComplexNumberType build() {
            return new ComplexNumberType(this);
        }
    }

    public static abstract class ComplexNumberTypeBuilder<C extends ComplexNumberType, B extends ComplexNumberTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Float real;
        private Float imaginary;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ComplexNumberTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ComplexNumberType instance, ComplexNumberTypeBuilder<?, ?> b) {
            b.real(instance.real);
            b.imaginary(instance.imaginary);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B real(Float real) {
            this.real = real;
            return (B)this.self();
        }

        public B imaginary(Float imaginary) {
            this.imaginary = imaginary;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ComplexNumberType.ComplexNumberTypeBuilder(super=" + super.toString() + ", real=" + this.real + ", imaginary=" + this.imaginary + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ComplexNumberType> {
        @Override
        public Class<ComplexNumberType> getType() {
            return ComplexNumberType.class;
        }

        @Override
        public ComplexNumberType decode(SerializationContext context, UaDecoder decoder) {
            Float real = decoder.readFloat("Real");
            Float imaginary = decoder.readFloat("Imaginary");
            return new ComplexNumberType(real, imaginary);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ComplexNumberType value) {
            encoder.writeFloat("Real", value.getReal());
            encoder.writeFloat("Imaginary", value.getImaginary());
        }
    }
}

