/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.data.ImportDataScanTool;
import org.apache.iotdb.tool.tsfile.ImportTsFileScanTool;

public abstract class AbstractImportData
extends AbstractDataTool
implements Runnable {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);

    public abstract void init() throws InterruptedException, IoTDBConnectionException, StatementExecutionException;

    @Override
    public void run() {
        String filePath = "";
        File file = null;
        try {
            if ("tsfile".equalsIgnoreCase(fileType)) {
                while ((filePath = ImportTsFileScanTool.pollFromQueue()) != null) {
                    file = new File(filePath);
                    if (!file.getName().endsWith("tsfile")) continue;
                    this.importFromTsFile(file);
                }
            } else {
                while ((filePath = ImportDataScanTool.pollFromQueue()) != null) {
                    file = new File(filePath);
                    if (file.getName().endsWith("sql")) {
                        this.importFromSqlFile(file);
                        continue;
                    }
                    this.importFromCsvFile(file);
                }
            }
        }
        catch (Exception e) {
            ioTPrinter.println(String.format("[%s] - Unexpected error occurred: %s", file.getName(), e.getMessage()));
        }
    }

    protected abstract Runnable getAsyncImportRunnable();

    public static void init(AbstractImportData instance) {
        instance.new ThreadManager().asyncImportDataFiles();
    }

    protected abstract void importFromSqlFile(File var1);

    protected abstract void importFromTsFile(File var1);

    protected abstract void importFromCsvFile(File var1);

    protected void processSuccessFile(String file) {
        loadFileSuccessfulNum.increment();
        if (fileType.equalsIgnoreCase("tsfile")) {
            try {
                this.processingFile(file, true);
                processingLoadSuccessfulFileSuccessfulNum.increment();
                ioTPrinter.println("Processed success file [ " + file + " ] successfully!");
            }
            catch (Exception processSuccessException) {
                ioTPrinter.println("Failed to process success file [ " + file + " ]: " + processSuccessException.getMessage());
            }
        }
    }

    protected void processingFile(String file, boolean isSuccess) {
        String relativePath = file.substring(ImportTsFileScanTool.getSourceFullPathLength() + 1);
        Path sourcePath = Paths.get(file, new String[0]);
        String target = isSuccess ? successDir : failDir + File.separator + relativePath.replace(File.separator, "_");
        Path targetPath = Paths.get(target, new String[0]);
        String RESOURCE = ".resource";
        Path sourceResourcePath = Paths.get(sourcePath + ".resource", new String[0]);
        sourceResourcePath = Files.exists(sourceResourcePath, new LinkOption[0]) ? sourceResourcePath : null;
        Path targetResourcePath = Paths.get(target + ".resource", new String[0]);
        String MODS = ".mods";
        Path sourceModsPath = Paths.get(sourcePath + ".mods", new String[0]);
        sourceModsPath = Files.exists(sourceModsPath, new LinkOption[0]) ? sourceModsPath : null;
        Path targetModsPath = Paths.get(target + ".mods", new String[0]);
        switch (isSuccess ? successOperation : failOperation) {
            case DELETE: {
                try {
                    Files.deleteIfExists(sourcePath);
                    if (null != sourceResourcePath) {
                        Files.deleteIfExists(sourceResourcePath);
                    }
                    if (null == sourceModsPath) break;
                    Files.deleteIfExists(sourceModsPath);
                }
                catch (Exception e) {
                    ioTPrinter.println(String.format("Failed to delete file: %s", e.getMessage()));
                }
                break;
            }
            case CP: {
                try {
                    Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    if (null != sourceResourcePath) {
                        Files.copy(sourceResourcePath, targetResourcePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (null == sourceModsPath) break;
                    Files.copy(sourceModsPath, targetModsPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    ioTPrinter.println(String.format("Failed to copy file: %s", e.getMessage()));
                }
                break;
            }
            case HARDLINK: {
                try {
                    Files.createLink(targetPath, sourcePath);
                }
                catch (FileAlreadyExistsException e) {
                    ioTPrinter.println("Hardlink already exists: " + e.getMessage());
                }
                catch (Exception e) {
                    try {
                        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception copyException) {
                        ioTPrinter.println(String.format("Failed to copy file: %s", copyException.getMessage()));
                    }
                }
                try {
                    if (null != sourceResourcePath) {
                        Files.copy(sourceResourcePath, targetResourcePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (null == sourceModsPath) break;
                    Files.copy(sourceModsPath, targetModsPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    ioTPrinter.println(String.format("Failed to copy resource or mods file: %s", e.getMessage()));
                }
                break;
            }
            case MV: {
                try {
                    Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    if (null != sourceResourcePath) {
                        Files.move(sourceResourcePath, targetResourcePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (null == sourceModsPath) break;
                    Files.move(sourceModsPath, targetModsPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    ioTPrinter.println(String.format("Failed to move file: %s", e.getMessage()));
                }
                break;
            }
        }
    }

    protected void processFailFile(String filePath, Exception e) {
        try {
            if (Objects.nonNull(e.getMessage()) && e.getMessage().contains("memory")) {
                ioTPrinter.println("Rejecting file [ " + filePath + " ] due to memory constraints, will retry later.");
                ImportTsFileScanTool.putToQueue(filePath);
                return;
            }
            loadFileFailedNum.increment();
            ioTPrinter.println("Failed to import [ " + filePath + " ] file: " + e.getMessage());
            try {
                this.processingFile(filePath, false);
                processingLoadFailedFileSuccessfulNum.increment();
                ioTPrinter.println("Processed fail file [ " + filePath + " ] successfully!");
            }
            catch (Exception processFailException) {
                ioTPrinter.println("Failed to process fail file [ " + filePath + " ]: " + processFailException.getMessage());
            }
        }
        catch (InterruptedException e1) {
            ioTPrinter.println("Unexpected error occurred: " + e1.getMessage());
            Thread.currentThread().interrupt();
        }
        catch (Exception e1) {
            ioTPrinter.println("Unexpected error occurred: " + e1.getMessage());
        }
    }

    protected class ThreadManager {
        protected ThreadManager() {
        }

        public void asyncImportDataFiles() {
            ArrayList<Thread> list = new ArrayList<Thread>(AbstractDataTool.threadNum);
            for (int i = 0; i < AbstractDataTool.threadNum; ++i) {
                Thread thread2 = new Thread(AbstractImportData.this.getAsyncImportRunnable());
                thread2.start();
                list.add(thread2);
            }
            list.forEach(thread -> {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    ioTPrinter.println("ImportData thread join interrupted: " + e.getMessage());
                }
            });
            ioTPrinter.println("Import completely!");
        }
    }
}

