/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.plugin.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class PipePluginMetaKeeper {
    protected final Map<String, PipePluginMeta> pipePluginNameToMetaMap = new ConcurrentHashMap<String, PipePluginMeta>();
    protected final Map<String, Class<?>> builtinPipePluginNameToClassMap = new ConcurrentHashMap();
    protected final Map<String, Visibility> pipePluginNameToVisibilityMap = new ConcurrentHashMap<String, Visibility>();

    public PipePluginMetaKeeper() {
        this.loadBuiltinPlugins();
    }

    private void loadBuiltinPlugins() {
        for (BuiltinPipePlugin builtinPipePlugin : BuiltinPipePlugin.values()) {
            String pipePluginName = builtinPipePlugin.getPipePluginName();
            Class<?> pipePluginClass = builtinPipePlugin.getPipePluginClass();
            String className = builtinPipePlugin.getClassName();
            this.addPipePluginMeta(pipePluginName, new PipePluginMeta(pipePluginName, className));
            this.addBuiltinPluginClass(pipePluginName, pipePluginClass);
            this.addPipePluginVisibility(pipePluginName, VisibilityUtils.calculateFromPluginClass(pipePluginClass));
        }
    }

    public void addPipePluginMeta(String pluginName, PipePluginMeta pipePluginMeta) {
        this.pipePluginNameToMetaMap.put(pluginName.toUpperCase(), pipePluginMeta);
    }

    public void removePipePluginMeta(String pluginName) {
        this.pipePluginNameToMetaMap.remove(pluginName.toUpperCase());
    }

    public PipePluginMeta getPipePluginMeta(String pluginName) {
        return this.pipePluginNameToMetaMap.get(pluginName.toUpperCase());
    }

    public Iterable<PipePluginMeta> getAllPipePluginMeta() {
        return this.pipePluginNameToMetaMap.values();
    }

    public boolean containsPipePlugin(String pluginName) {
        return this.pipePluginNameToMetaMap.containsKey(pluginName.toUpperCase());
    }

    private void addBuiltinPluginClass(String pluginName, Class<?> builtinPipePluginClass) {
        this.builtinPipePluginNameToClassMap.put(pluginName.toUpperCase(), builtinPipePluginClass);
    }

    public Class<?> getBuiltinPluginClass(String pluginName) {
        return this.builtinPipePluginNameToClassMap.get(pluginName.toUpperCase());
    }

    public String getPluginNameByJarName(String jarName) {
        for (Map.Entry<String, PipePluginMeta> entry : this.pipePluginNameToMetaMap.entrySet()) {
            if (!jarName.equals(entry.getValue().getJarName())) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addPipePluginVisibility(String pluginName, Visibility visibility) {
        this.pipePluginNameToVisibilityMap.put(pluginName.toUpperCase(), visibility);
    }

    public void removePipePluginVisibility(String pluginName) {
        this.pipePluginNameToVisibilityMap.remove(pluginName.toUpperCase());
    }

    public boolean visibleUnder(String pluginName, boolean isTableModel) {
        Visibility visibility = this.pipePluginNameToVisibilityMap.get(pluginName);
        if (Objects.isNull((Object)visibility)) {
            return false;
        }
        return VisibilityUtils.isCompatible(visibility, isTableModel);
    }

    public Map<String, Visibility> getPipePluginNameToVisibilityMap() {
        return Collections.unmodifiableMap(this.pipePluginNameToVisibilityMap);
    }

    protected void processTakeSnapshot(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)((int)this.pipePluginNameToMetaMap.values().stream().filter(pipePluginMeta -> !pipePluginMeta.isBuiltin()).count()), (OutputStream)outputStream);
        for (PipePluginMeta pipePluginMeta2 : this.pipePluginNameToMetaMap.values()) {
            if (pipePluginMeta2.isBuiltin()) continue;
            ReadWriteIOUtils.write((ByteBuffer)pipePluginMeta2.serialize(), (OutputStream)outputStream);
        }
    }

    protected void processLoadSnapshot(InputStream inputStream) throws IOException {
        this.pipePluginNameToMetaMap.forEach((pluginName, pluginMeta) -> {
            if (!pluginMeta.isBuiltin()) {
                this.pipePluginNameToMetaMap.remove(pluginName);
            }
        });
        int pipePluginMetaSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < pipePluginMetaSize; ++i) {
            PipePluginMeta pipePluginMeta = PipePluginMeta.deserialize(inputStream);
            this.addPipePluginMeta(pipePluginMeta.getPluginName().toUpperCase(), pipePluginMeta);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipePluginMetaKeeper that = (PipePluginMetaKeeper)o;
        return this.pipePluginNameToMetaMap.equals(that.pipePluginNameToMetaMap);
    }

    public int hashCode() {
        return Objects.hash(this.pipePluginNameToMetaMap);
    }
}

