/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.AuthenticationChallenge;
import org.apache.james.jmap.http.AuthenticationScheme;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public class JWTAuthenticationStrategy
implements AuthenticationStrategy {
    @VisibleForTesting
    public static final String AUTHORIZATION_HEADER_PREFIX = "Bearer ";
    private final JwtTokenVerifier tokenManager;
    private final MailboxManager mailboxManager;
    private final UsersRepository usersRepository;

    @Inject
    @VisibleForTesting
    public JWTAuthenticationStrategy(@Named(value="jmap") JwtTokenVerifier tokenManager, MailboxManager mailboxManager, UsersRepository usersRepository) {
        this.tokenManager = tokenManager;
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
    }

    @Override
    public Mono<MailboxSession> createMailboxSession(HttpServerRequest httpRequest) {
        return Mono.fromCallable(() -> this.authHeaders(httpRequest)).filter(header -> header.startsWith(AUTHORIZATION_HEADER_PREFIX)).map(header -> header.substring(AUTHORIZATION_HEADER_PREFIX.length())).flatMap(userJWTToken -> Mono.fromCallable(() -> {
            Username username = this.tokenManager.verifyAndExtractLogin(userJWTToken).map(Username::of).orElseThrow(() -> new UnauthorizedException("Failed Jwt verification"));
            try {
                this.usersRepository.assertValid(username);
            }
            catch (UsersRepositoryException e) {
                throw new UnauthorizedException("Invalid username", e);
            }
            return username;
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER)).map((Function)Throwing.function(user -> this.mailboxManager.authenticate(user).withoutDelegation()));
    }

    @Override
    public AuthenticationChallenge correspondingChallenge() {
        return AuthenticationChallenge.of(AuthenticationScheme.of("Bearer"), (Map<String, String>)ImmutableMap.of((Object)"realm", (Object)"JWT"));
    }
}

