/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.function.Supplier;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class ContextAccumulator {
    private Context addedContext = new Context();
    private Context baseContext = null;
    private Context builtContext = null;

    public static ContextAccumulator newBuilder() {
        return new ContextAccumulator();
    }

    public static ContextAccumulator newBuilder(Supplier<Context> baseSupplier) {
        return ContextAccumulator.newBuilder(baseSupplier, null);
    }

    public static ContextAccumulator newBuilder(final Supplier<Context> baseSupplier, final Supplier<Context> extraSupplier) {
        return new ContextAccumulator(){

            @Override
            protected Context baseContext() {
                if (baseSupplier == null) {
                    return null;
                }
                return (Context)baseSupplier.get();
            }

            @Override
            protected Context extra() {
                if (extraSupplier == null) {
                    return null;
                }
                return (Context)extraSupplier.get();
            }
        };
    }

    private ContextAccumulator() {
    }

    protected Context extra() {
        return null;
    }

    protected Context baseContext() {
        return ARQ.getContext();
    }

    public ContextAccumulator set(Symbol symbol, Object value) {
        this.update();
        this.addedContext.set(symbol, value);
        return this;
    }

    public ContextAccumulator set(Symbol symbol, boolean value) {
        this.update();
        this.addedContext.set(symbol, value);
        return this;
    }

    public ContextAccumulator context(Context context2) {
        if (context2 == null) {
            return this;
        }
        this.update();
        this.addedContext.clear();
        this.baseContext = context2;
        return this;
    }

    public Context context() {
        return this.getOrBuildContext();
    }

    public ContextAccumulator clone() {
        ContextAccumulator clone = new ContextAccumulator();
        clone.addedContext.putAll(this.addedContext);
        if (this.baseContext != null) {
            clone.baseContext = this.baseContext.copy();
        }
        return clone;
    }

    private void update() {
        this.builtContext = null;
    }

    private Context getOrBuildContext() {
        if (this.builtContext == null) {
            this.builtContext = this.buildProcess();
        }
        return this.builtContext;
    }

    private Context buildProcess() {
        Context cxt;
        if (this.baseContext != null) {
            cxt = this.baseContext;
        } else {
            Context dftCxt = this.baseContext();
            cxt = dftCxt != null ? dftCxt.copy() : new Context();
            Context extra = this.extra();
            if (extra != null) {
                cxt.putAll(extra);
            }
        }
        if (this.addedContext != null) {
            cxt.putAll(this.addedContext);
        }
        return cxt;
    }
}

