/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.command.completers.LoginModuleNameCompleter;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.config.impl.Config;
import org.apache.karaf.jaas.config.impl.Module;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="jaas", name="module-add", description="Add a Login Module")
@Service
public class ModuleAddCommand
extends JaasCommandSupport {
    @Argument(index=0, name="loginModule", description="Class Name of Login Module", required=true, multiValued=false)
    @Completion(value=LoginModuleNameCompleter.class)
    private String loginModule;
    @Argument(index=1, name="properties", description="Pair of Properties (key value)", required=false, multiValued=true)
    private List<String> propertiesList;

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }

    @Override
    public Object execute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        if (realm == null) {
            System.err.println("No JAAS Realm has been selected");
            throw new IllegalStateException("No JAAS Realm has been selected");
        }
        if (!(realm instanceof Config)) {
            System.err.println("Selected JAAS Realm was not added via jaas:add-realm, only those are supported!");
            throw new IllegalStateException("Selected JAAS Realm was not added via jaas:add-realm, only those are supported!");
        }
        if (!this.checkIfClassExists(this.loginModule)) {
            System.err.println("Module class '" + this.loginModule + "' is unknown!");
            throw new IllegalArgumentException("Module class '" + this.loginModule + "' is unknown!");
        }
        Module module = ModuleAddCommand.createModuleFromCmdParameters(this.loginModule, this.propertiesList);
        ArrayList<Module> modulesList = new ArrayList<Module>(Arrays.asList(((Config)realm).getModules()));
        modulesList.add(module);
        Module[] newModules = modulesList.toArray(new Module[0]);
        ((Config)realm).setModules(newModules);
        return null;
    }

    static Module createModuleFromCmdParameters(String loginModule, List<String> propertiesList) {
        if (propertiesList != null && propertiesList.size() > 0 && propertiesList.size() % 2 == 1) {
            System.err.println("Properties have to be given as \"key1 value1 key2 value2 ...\" but number of Arguments is uneven!");
            return null;
        }
        Properties properties = new Properties();
        if (propertiesList != null) {
            for (int i = 0; i < propertiesList.size(); i += 2) {
                properties.put(propertiesList.get(i), propertiesList.get(i + 1));
            }
        }
        Module module = new Module();
        module.setClassName(loginModule);
        module.setFlags("required");
        module.setOptions(properties);
        return module;
    }

    public String getLoginModule() {
        return this.loginModule;
    }

    public void setLoginModule(String loginModule) {
        this.loginModule = loginModule;
    }

    public List<String> getPropertiesList() {
        return this.propertiesList;
    }

    public void setPropertiesList(List<String> propertiesList) {
        this.propertiesList = propertiesList;
    }

    private boolean checkIfClassExists(String loginModule) {
        try {
            this.getClass().getClassLoader().loadClass(loginModule);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

