/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.filenet;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.common.filenet.DocumentClassDefinition;
import org.apache.manifoldcf.crawler.common.filenet.FileInfo;
import org.apache.manifoldcf.crawler.common.filenet.FilenetException;
import org.apache.manifoldcf.crawler.common.filenet.IFilenet;
import org.apache.manifoldcf.crawler.common.filenet.IFilenetFactory;
import org.apache.manifoldcf.crawler.common.filenet.MetadataFieldDefinition;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.filenet.DocClassSpec;
import org.apache.manifoldcf.crawler.connectors.filenet.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.ui.util.Encoder;

public class FilenetConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: FilenetConnector.java 996524 2010-09-13 13:38:01Z kwright $";
    public static final String CONFIG_PARAM_USERID = "User ID";
    public static final String CONFIG_PARAM_PASSWORD = "Password";
    public static final String CONFIG_PARAM_FILENETDOMAIN_OLD = "Filenet domain";
    public static final String CONFIG_PARAM_FILENETDOMAIN = "FileNet domain";
    public static final String CONFIG_PARAM_OBJECTSTORE = "Object store";
    public static final String CONFIG_PARAM_SERVERPROTOCOL = "Server protocol";
    public static final String CONFIG_PARAM_SERVERHOSTNAME = "Server hostname";
    public static final String CONFIG_PARAM_SERVERPORT = "Server port";
    public static final String CONFIG_PARAM_SERVERWSILOCATION = "Server WebServices location";
    public static final String CONFIG_PARAM_URLPROTOCOL = "Document URL protocol";
    public static final String CONFIG_PARAM_URLHOSTNAME = "Document URL hostname";
    public static final String CONFIG_PARAM_URLPORT = "Document URL port";
    public static final String CONFIG_PARAM_URLLOCATION = "Document URL location";
    public static final String SPEC_NODE_FOLDER = "folder";
    public static final String SPEC_NODE_MIMETYPE = "mimetype";
    public static final String SPEC_NODE_DOCUMENTCLASS = "documentclass";
    public static final String SPEC_NODE_METADATAFIELD = "metafield";
    public static final String SPEC_NODE_MATCH = "match";
    public static final String SPEC_ATTRIBUTE_VALUE = "value";
    public static final String SPEC_ATTRIBUTE_ALLMETADATA = "allmetadata";
    public static final String SPEC_ATTRIBUTE_MATCHTYPE = "matchtype";
    public static final String SPEC_ATTRIBUTE_FIELDNAME = "fieldname";
    public static final String ACTIVITY_FETCH = "fetch";
    protected static final long timeToRelease = 300000L;
    protected IFilenet session = null;
    protected long lastSessionFetch = -1L;
    protected String userID = null;
    protected String password = null;
    protected String filenetDomain = null;
    protected String objectStore = null;
    protected String serverProtocol = null;
    protected String serverHostname = null;
    protected String serverPort = null;
    protected String serverLocation = null;
    protected String serverWSIURI = null;
    protected String docUrlServerProtocol = null;
    protected String docUrlServerName = null;
    protected String docUrlPort = null;
    protected String docUrlLocation = null;
    protected String docURIPrefix = null;
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (this.userID == null || this.userID.length() < 1) {
                throw new ManifoldCFException("Parameter User ID required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("FileNet: UserID = '" + this.userID + "'"));
            }
            if (this.password == null || this.password.length() < 1) {
                throw new ManifoldCFException("Parameter Password required but not set");
            }
            Logging.connectors.debug((Object)"FileNet: Password exists");
            if (this.objectStore == null || this.objectStore.length() < 1) {
                throw new ManifoldCFException("Parameter Object store required but not set");
            }
            if (this.serverProtocol == null || this.serverProtocol.length() < 1) {
                throw new ManifoldCFException("Parameter Server protocol required but not set");
            }
            if (this.serverHostname == null || this.serverHostname.length() < 1) {
                throw new ManifoldCFException("Parameter Server hostname required but not set");
            }
            if (this.serverPort != null && this.serverPort.length() < 1) {
                this.serverPort = null;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("FileNet: Server URI is '" + this.serverWSIURI + "'"));
            }
            if (this.docUrlServerProtocol == null || this.docUrlServerProtocol.length() == 0) {
                throw new ManifoldCFException("Parameter Document URL protocol required but not set");
            }
            if (this.docUrlServerName == null || this.docUrlServerName.length() == 0) {
                throw new ManifoldCFException("Parameter Document URL hostname required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("FileNet: Document base URI is '" + this.docURIPrefix + "'"));
            }
            GetSessionThread t = new GetSessionThread();
            t.start();
            try {
                t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (MalformedURLException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            catch (NotBoundException e) {
                Logging.connectors.warn((Object)("FileNet: RMI server not up at the moment: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                Logging.connectors.warn((Object)("FileNet: Transient remote exception creating session: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
            catch (FilenetException e) {
                if (e.getType() == 0) {
                    Logging.connectors.warn((Object)("FileNet: Remote service interruption creating session: " + e.getMessage()), (Throwable)e);
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
                }
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
    }

    protected void releaseCheck() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            t.start();
            try {
                t.finishUp();
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("FileNet: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
            catch (FilenetException e) {
                this.session = null;
                this.lastSessionFetch = -1L;
                if (e.getType() == 0) {
                    Logging.connectors.warn((Object)("FileNet: Remote service interruption closing session: " + e.getMessage()), (Throwable)e);
                }
                Logging.connectors.warn((Object)("FileNet: Error closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public int getConnectorModel() {
        return 1;
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.serverHostname};
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH};
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.userID = configParams.getParameter(CONFIG_PARAM_USERID);
        this.password = configParams.getObfuscatedParameter(CONFIG_PARAM_PASSWORD);
        this.filenetDomain = configParams.getParameter(CONFIG_PARAM_FILENETDOMAIN);
        if (this.filenetDomain == null) {
            this.filenetDomain = configParams.getParameter(CONFIG_PARAM_FILENETDOMAIN_OLD);
            if (this.filenetDomain == null) {
                this.filenetDomain = "";
            }
        }
        this.objectStore = configParams.getParameter(CONFIG_PARAM_OBJECTSTORE);
        this.serverProtocol = configParams.getParameter(CONFIG_PARAM_SERVERPROTOCOL);
        this.serverHostname = configParams.getParameter(CONFIG_PARAM_SERVERHOSTNAME);
        this.serverPort = configParams.getParameter(CONFIG_PARAM_SERVERPORT);
        if (this.serverPort != null && this.serverPort.length() < 1) {
            this.serverPort = null;
        }
        this.serverLocation = configParams.getParameter(CONFIG_PARAM_SERVERWSILOCATION);
        if (this.serverLocation != null && this.serverLocation.length() < 1) {
            this.serverLocation = null;
        }
        this.serverWSIURI = (this.serverProtocol == null ? "" : this.serverProtocol) + "://" + (this.serverHostname == null ? "" : this.serverHostname);
        if (this.serverPort != null) {
            this.serverWSIURI = this.serverWSIURI + ":" + this.serverPort;
        }
        if (this.serverLocation != null) {
            this.serverWSIURI = this.serverWSIURI + "/" + this.serverLocation;
        }
        this.docUrlServerProtocol = configParams.getParameter(CONFIG_PARAM_URLPROTOCOL);
        this.docUrlServerName = configParams.getParameter(CONFIG_PARAM_URLHOSTNAME);
        this.docUrlPort = configParams.getParameter(CONFIG_PARAM_URLPORT);
        if (this.docUrlPort != null && this.docUrlPort.length() < 1) {
            this.docUrlPort = null;
        }
        this.docUrlLocation = configParams.getParameter(CONFIG_PARAM_URLLOCATION);
        if (this.docUrlLocation != null && this.docUrlLocation.length() < 1) {
            this.docUrlLocation = null;
        }
        this.docURIPrefix = (this.docUrlServerProtocol == null ? "" : this.docUrlServerProtocol) + "://" + (this.docUrlServerName == null ? "" : this.docUrlServerName);
        if (this.docUrlPort != null) {
            this.docURIPrefix = this.docURIPrefix + ":" + this.docUrlPort;
        }
        if (this.docUrlLocation != null) {
            this.docURIPrefix = this.docURIPrefix + "/" + this.docUrlLocation;
        }
        this.docURIPrefix = this.docURIPrefix + "/getContent?objectStoreName=" + (this.objectStore == null ? "" : this.objectStore);
    }

    public String check() throws ManifoldCFException {
        try {
            try {
                this.checkConnection();
                return super.check();
            }
            catch (FilenetException e) {
                if (e.getType() == 0) {
                    throw new ServiceInterruption(e.getMessage(), 0L);
                }
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public void poll() throws ManifoldCFException {
        this.releaseCheck();
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            DestroySessionThread t = new DestroySessionThread();
            t.start();
            try {
                t.finishUp();
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("FileNet: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
            catch (FilenetException e) {
                this.session = null;
                this.lastSessionFetch = -1L;
                if (e.getType() == 0) {
                    Logging.connectors.warn((Object)("FileNet: Remote service interruption closing session: " + e.getMessage()), (Throwable)e);
                }
                Logging.connectors.warn((Object)("FileNet: Error closing session: " + e.getMessage()), (Throwable)e);
            }
        }
        this.userID = null;
        this.password = null;
        this.objectStore = null;
        this.serverWSIURI = null;
        this.serverHostname = null;
        this.docURIPrefix = null;
    }

    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        if (command.startsWith("metadatafields/")) {
            String documentClass = command.substring("metadatafields/".length());
            try {
                MetadataFieldDefinition[] metaFields = this.getDocumentClassMetadataFieldsDetails(documentClass);
                int i = 0;
                while (i < metaFields.length) {
                    MetadataFieldDefinition def = metaFields[i++];
                    ConfigurationNode node = new ConfigurationNode("metadata_field");
                    ConfigurationNode child = new ConfigurationNode("display_name");
                    child.setValue(def.getDisplayName());
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("symbolic_name");
                    child.setValue(def.getSymbolicName());
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.equals("documentclasses")) {
            try {
                DocumentClassDefinition[] definitions = this.getDocumentClassesDetails();
                int i = 0;
                while (i < definitions.length) {
                    DocumentClassDefinition def = definitions[i++];
                    ConfigurationNode node = new ConfigurationNode("document_class");
                    ConfigurationNode child = new ConfigurationNode("display_name");
                    child.setValue(def.getDisplayName());
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("symbolic_name");
                    child.setValue(def.getSymbolicName());
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.equals("mimetypes")) {
            try {
                String[] mimeTypesArray = this.getMimeTypes();
                int i = 0;
                while (i < mimeTypesArray.length) {
                    String mimeType = mimeTypesArray[i++];
                    ConfigurationNode node = new ConfigurationNode("mime_type");
                    node.setValue(mimeType);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            return super.requestInfo(output, command);
        }
        return true;
    }

    public String[] getChildFolders(String folderName) throws ManifoldCFException, ServiceInterruption {
        try {
            String[] folderPath;
            Object[] rval;
            if (folderName.startsWith("/")) {
                folderName = folderName.substring(1);
            }
            if ((rval = this.doGetChildFolders(folderPath = folderName.length() == 0 ? new String[]{} : folderName.split("/"))) == null) {
                return null;
            }
            Arrays.sort(rval);
            return rval;
        }
        catch (FilenetException e) {
            if (e.getType() == 0) {
                throw new ServiceInterruption(e.getMessage(), 0L);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String mimeType;
        int i;
        Logging.connectors.debug((Object)"FileNet: Inside addSeedDocuments");
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        StringBuilder mimeTypesClause = new StringBuilder();
        for (i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode n = spec.getChild(i);
            if (!n.getType().equals(SPEC_NODE_MIMETYPE) || (mimeType = n.getAttributeValue(SPEC_ATTRIBUTE_VALUE)) == null) continue;
            if (mimeTypesClause.length() != 0) {
                mimeTypesClause.append(" or ");
            }
            mimeTypesClause.append("[MimeType] = '").append(mimeType).append("'");
        }
        if (mimeTypesClause.length() == 0) {
            String[] mimeTypes = this.getMimeTypes();
            i = 0;
            while (i < mimeTypes.length) {
                mimeType = mimeTypes[i++];
                if (mimeTypesClause.length() != 0) {
                    mimeTypesClause.append(" or ");
                }
                mimeTypesClause.append("[MimeType] = '").append(mimeType).append("'");
            }
        }
        StringBuilder sqlBuffer = new StringBuilder(" WHERE ([IsCurrentVersion] = TRUE AND (");
        sqlBuffer.append((CharSequence)mimeTypesClause);
        sqlBuffer.append(")");
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        long biasTime = 900000L;
        startTime = startTime < biasTime ? 0L : (startTime -= biasTime);
        if (startTime > 0L) {
            sqlBuffer.append(" AND [DateLastModified] >= ").append(FilenetConnector.buildTime(c, startTime));
        }
        sqlBuffer.append(" AND  [DateLastModified] <= ").append(FilenetConnector.buildTime(c, seedTime));
        boolean seenAny = false;
        i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode n;
            if (!(n = spec.getChild(i++)).getType().equals(SPEC_NODE_FOLDER)) continue;
            if (!seenAny) {
                sqlBuffer.append(" AND (");
                seenAny = true;
            } else {
                sqlBuffer.append(" or ");
            }
            String folderValue = n.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            sqlBuffer.append("This INSUBFOLDER " + FilenetConnector.quoteSQLString(folderValue));
        }
        if (seenAny) {
            sqlBuffer.append(")");
        }
        String whereClause = sqlBuffer.toString();
        for (i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode n = spec.getChild(i);
            if (!n.getType().equals(SPEC_NODE_DOCUMENTCLASS)) continue;
            String dc = n.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            DocClassSpec dcs = new DocClassSpec(n);
            int matchCount = dcs.getMatchCount();
            StringBuilder moreWhereClause = new StringBuilder(whereClause);
            for (int q = 0; q < matchCount; ++q) {
                String matchType = dcs.getMatchType(q);
                String matchField = dcs.getMatchField(q);
                String matchValue = dcs.getMatchValue(q);
                moreWhereClause.append(" AND [").append(matchField).append("] ").append(matchType).append(" ").append(FilenetConnector.quoteSQLString(matchValue));
            }
            moreWhereClause.append(")");
            String fullSQL = "SELECT Id, [VersionSeries] FROM " + dc + " WITH EXCLUDESUBCLASSES " + moreWhereClause.toString() + " OPTIONS(TIMELIMIT 180)";
            try {
                String[] objectIds = this.doGetMatchingObjectIds(fullSQL);
                int j = 0;
                while (j < objectIds.length) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("FileNet: Seeding with identifier '" + objectIds[j] + "'"));
                    }
                    activities.addSeedDocument(objectIds[j++]);
                }
                continue;
            }
            catch (FilenetException e) {
                long currentTime = System.currentTimeMillis();
                if (e.getType() == 0) {
                    throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
                }
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        return new Long(seedTime).toString();
    }

    protected static String quoteSQLString(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\'') {
                sb.append('\'');
            }
            sb.append(x);
        }
        sb.append('\'');
        return sb.toString();
    }

    protected static String buildTime(Calendar c, long timeValue) {
        c.setTimeInMillis(timeValue);
        StringBuilder rval = new StringBuilder();
        FilenetConnector.print_int(rval, c.get(1), 4);
        FilenetConnector.print_int(rval, c.get(2) + 1, 2);
        FilenetConnector.print_int(rval, c.get(5), 2);
        rval.append("T");
        FilenetConnector.print_int(rval, c.get(11), 2);
        FilenetConnector.print_int(rval, c.get(12), 2);
        FilenetConnector.print_int(rval, c.get(13), 2);
        rval.append("Z");
        return rval.toString();
    }

    protected static void print_int(StringBuilder sb, int value, int digits) {
        if (digits == 4) {
            value = FilenetConnector.print_digit(sb, value, 1000);
            --digits;
        }
        if (digits == 3) {
            value = FilenetConnector.print_digit(sb, value, 100);
            --digits;
        }
        if (digits == 2) {
            value = FilenetConnector.print_digit(sb, value, 10);
            --digits;
        }
        if (digits == 1) {
            FilenetConnector.print_digit(sb, value, 1);
        }
    }

    protected static int print_digit(StringBuilder sb, int value, int divisor) {
        int digit = value / divisor;
        int x = 48 + digit;
        sb.append((char)x);
        return value - digit * divisor;
    }

    /*
     * Exception decompiling
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void handleIOException(IOException e, String documentIdentifier, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketTimeoutException) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Socket timeout " + context + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 3600000L, 5, true);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.error((Object)("FileNet: IO exception on '" + documentIdentifier + "' while " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("IO exception " + context + ": " + e.getMessage(), (Throwable)e);
    }

    protected static boolean performMatch(String matchType, String matchDocValue, String matchValue) {
        if (matchType.equals("=")) {
            return matchDocValue.equalsIgnoreCase(matchValue);
        }
        if (matchType.equals("!=")) {
            return !matchDocValue.equalsIgnoreCase(matchValue);
        }
        return FilenetConnector.likeMatch(matchDocValue, 0, matchValue, 0);
    }

    protected static boolean likeMatch(String matchDocValue, int matchDocPos, String matchValue, int matchPos) {
        if (matchPos == matchValue.length()) {
            return matchDocPos == matchDocValue.length();
        }
        if (matchDocPos == matchDocValue.length()) {
            return matchValue.charAt(matchPos) == '%' && FilenetConnector.likeMatch(matchDocValue, matchDocPos, matchValue, matchPos + 1);
        }
        char x = matchDocValue.charAt(matchDocPos);
        char y = matchValue.charAt(matchPos);
        if (y != '%') {
            return Character.toLowerCase(x) == Character.toLowerCase(y) && FilenetConnector.likeMatch(matchDocValue, matchDocPos + 1, matchValue, matchPos + 1);
        }
        return FilenetConnector.likeMatch(matchDocValue, matchDocPos + 1, matchValue, matchPos) || FilenetConnector.likeMatch(matchDocValue, matchDocPos, matchValue, matchPos + 1);
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "FilenetConnector.Server"));
        tabsArray.add(Messages.getString(locale, "FilenetConnector.ObjectStore"));
        tabsArray.add(Messages.getString(locale, "FilenetConnector.DocumentURL"));
        tabsArray.add(Messages.getString(locale, "FilenetConnector.Credentials"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheServerPortMustBeAnInteger") + "\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.urlport.value != \"\" && !isInteger(editconnection.urlport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheDocumentURLPortMustBeAnInteger") + "\");\n    editconnection.urlport.focus();\n    return false;\n  }\n\n  return true;\n}\n\t\nfunction checkConfigForSave()\n{\n  if (editconnection.serverhostname.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheConnectionRequiresAFileNetHostName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.Server") + "\");\n    editconnection.serverhostname.focus();\n    return false;\n  }\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheServerPortMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.Server") + "\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.urlhostname.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheDocumentURLRequiresAHostName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.DocumentURL") + "\");\n    editconnection.urlhostname.focus();\n    return false;\n  }\n  if (editconnection.urlport.value != \"\" && !isInteger(editconnection.urlport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheDocumentURLPortMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.DocumentURL") + "\");\n    editconnection.urlport.focus();\n    return false;\n  }\n\n  if (editconnection.filenetdomain.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheFileNetDomainNameCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.ObjectStore") + "\");\n    editconnection.filenetdomain.focus();\n    return false;\n  }\n  if (editconnection.objectstore.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheObjectStoreNameCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.ObjectStore") + "\");\n    editconnection.objectstore.focus();\n    return false;\n  }\n  if (editconnection.userid.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheConnectionRequiresAValidFileNetUserID") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.Credentials") + "\");\n    editconnection.userid.focus();\n    return false;\n  }\n  if (editconnection.password.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.TheConnectionRequiresTheFileNetUsersPassword") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.Credentials") + "\");\n    editconnection.password.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String urllocation;
        String urlport;
        String urlhostname;
        String urlprotocol;
        String serverwsilocation;
        String serverport;
        String serverhostname;
        String serverprotocol;
        String objectstore;
        String password;
        String userID = parameters.getParameter(CONFIG_PARAM_USERID);
        if (userID == null) {
            userID = "";
        }
        password = (password = parameters.getObfuscatedParameter(CONFIG_PARAM_PASSWORD)) == null ? "" : out.mapPasswordToKey(password);
        String filenetdomain = parameters.getParameter(CONFIG_PARAM_FILENETDOMAIN);
        if (filenetdomain == null && (filenetdomain = parameters.getParameter(CONFIG_PARAM_FILENETDOMAIN_OLD)) == null) {
            filenetdomain = "";
        }
        if ((objectstore = parameters.getParameter(CONFIG_PARAM_OBJECTSTORE)) == null) {
            objectstore = "";
        }
        if ((serverprotocol = parameters.getParameter(CONFIG_PARAM_SERVERPROTOCOL)) == null) {
            serverprotocol = "http";
        }
        if ((serverhostname = parameters.getParameter(CONFIG_PARAM_SERVERHOSTNAME)) == null) {
            serverhostname = "";
        }
        if ((serverport = parameters.getParameter(CONFIG_PARAM_SERVERPORT)) == null) {
            serverport = "";
        }
        if ((serverwsilocation = parameters.getParameter(CONFIG_PARAM_SERVERWSILOCATION)) == null) {
            serverwsilocation = "wsi/FNCEWS40DIME";
        }
        if ((urlprotocol = parameters.getParameter(CONFIG_PARAM_URLPROTOCOL)) == null) {
            urlprotocol = "http";
        }
        if ((urlhostname = parameters.getParameter(CONFIG_PARAM_URLHOSTNAME)) == null) {
            urlhostname = "";
        }
        if ((urlport = parameters.getParameter(CONFIG_PARAM_URLPORT)) == null) {
            urlport = "";
        }
        if ((urllocation = parameters.getParameter(CONFIG_PARAM_URLLOCATION)) == null) {
            urllocation = "Workplace/Browse.jsp";
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.Server"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.ServerProtocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"serverprotocol\" size=\"2\">\n        <option value=\"http\" " + (serverprotocol.equals("http") ? "selected=\"true\"" : "") + ">http</option>\n        <option value=\"https\" " + (serverprotocol.equals("https") ? "selected=\"true\"" : "") + ">https</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.ServerHostName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"serverhostname\" value=\"" + Encoder.attributeEscape((String)serverhostname) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.ServerPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"serverport\" value=\"" + Encoder.attributeEscape((String)serverport) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.ServerWebServiceLocation") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"serverwsilocation\" value=\"" + Encoder.attributeEscape((String)serverwsilocation) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"serverprotocol\" value=\"" + Encoder.attributeEscape((String)serverprotocol) + "\"/>\n<input type=\"hidden\" name=\"serverhostname\" value=\"" + Encoder.attributeEscape((String)serverhostname) + "\"/>\n<input type=\"hidden\" name=\"serverport\" value=\"" + Encoder.attributeEscape((String)serverport) + "\"/>\n<input type=\"hidden\" name=\"serverwsilocation\" value=\"" + Encoder.attributeEscape((String)serverwsilocation) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.DocumentURL"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.DocumentURLProtocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"urlprotocol\" size=\"2\">\n        <option value=\"http\" " + (serverprotocol.equals("http") ? "selected=\"true\"" : "") + ">http</option>\n        <option value=\"https\" " + (serverprotocol.equals("https") ? "selected=\"true\"" : "") + ">https</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.DocumentURLHostName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"urlhostname\" value=\"" + Encoder.attributeEscape((String)urlhostname) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.DocumentURLPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"urlport\" value=\"" + Encoder.attributeEscape((String)urlport) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.DocumentURLLocation") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"urllocation\" value=\"" + Encoder.attributeEscape((String)urllocation) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"urlprotocol\" value=\"" + Encoder.attributeEscape((String)urlprotocol) + "\"/>\n<input type=\"hidden\" name=\"urlhostname\" value=\"" + Encoder.attributeEscape((String)urlhostname) + "\"/>\n<input type=\"hidden\" name=\"urlport\" value=\"" + Encoder.attributeEscape((String)urlport) + "\"/>\n<input type=\"hidden\" name=\"urllocation\" value=\"" + Encoder.attributeEscape((String)urllocation) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.ObjectStore"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.FileNetDomainName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"filenetdomain\" value=\"" + Encoder.attributeEscape((String)filenetdomain) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.ObjectStoreName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"objectstore\" value=\"" + Encoder.attributeEscape((String)objectstore) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"filenetdomain\" value=\"" + Encoder.attributeEscape((String)filenetdomain) + "\"/>\n<input type=\"hidden\" name=\"objectstore\" value=\"" + Encoder.attributeEscape((String)objectstore) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.Credentials"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.UserID") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"userid\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.Password") + "</nobr></td><td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"userid\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/>\n<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String objectstore;
        String filenetdomain;
        String password;
        String userID;
        String urllocation;
        String urlport;
        String urlhostname;
        String urlprotocol;
        String serverwsilocation;
        String serverport;
        String serverhostname;
        String serverprotocol = variableContext.getParameter("serverprotocol");
        if (serverprotocol != null) {
            parameters.setParameter(CONFIG_PARAM_SERVERPROTOCOL, serverprotocol);
        }
        if ((serverhostname = variableContext.getParameter("serverhostname")) != null) {
            parameters.setParameter(CONFIG_PARAM_SERVERHOSTNAME, serverhostname);
        }
        if ((serverport = variableContext.getParameter("serverport")) != null && serverport.length() > 0) {
            parameters.setParameter(CONFIG_PARAM_SERVERPORT, serverport);
        }
        if ((serverwsilocation = variableContext.getParameter("serverwsilocation")) != null) {
            parameters.setParameter(CONFIG_PARAM_SERVERWSILOCATION, serverwsilocation);
        }
        if ((urlprotocol = variableContext.getParameter("urlprotocol")) != null) {
            parameters.setParameter(CONFIG_PARAM_URLPROTOCOL, urlprotocol);
        }
        if ((urlhostname = variableContext.getParameter("urlhostname")) != null) {
            parameters.setParameter(CONFIG_PARAM_URLHOSTNAME, urlhostname);
        }
        if ((urlport = variableContext.getParameter("urlport")) != null && urlport.length() > 0) {
            parameters.setParameter(CONFIG_PARAM_URLPORT, urlport);
        }
        if ((urllocation = variableContext.getParameter("urllocation")) != null) {
            parameters.setParameter(CONFIG_PARAM_URLLOCATION, urllocation);
        }
        if ((userID = variableContext.getParameter("userid")) != null) {
            parameters.setParameter(CONFIG_PARAM_USERID, userID);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter(CONFIG_PARAM_PASSWORD, variableContext.mapKeyToPassword(password));
        }
        if ((filenetdomain = variableContext.getParameter("filenetdomain")) != null) {
            parameters.setParameter(CONFIG_PARAM_FILENETDOMAIN, filenetdomain);
        }
        if ((objectstore = variableContext.getParameter("objectstore")) != null) {
            parameters.setParameter(CONFIG_PARAM_OBJECTSTORE, objectstore);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        tabsArray.add(Messages.getString(locale, "FilenetConnector.DocumentClasses"));
        tabsArray.add(Messages.getString(locale, "FilenetConnector.MimeTypes"));
        tabsArray.add(Messages.getString(locale, "FilenetConnector.Folders"));
        tabsArray.add(Messages.getString(locale, "FilenetConnector.Security"));
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddToPath(anchorvalue)\n{\n  if (editjob." + seqPrefix + "pathaddon.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.SelectAFolderFirst") + "\");\n    editjob." + seqPrefix + "pathaddon.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\",\"AddToPath\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddMatch(docclass, anchorvalue)\n{\n  if (eval(\"editjob." + seqPrefix + "matchfield_\"+docclass+\".value\") == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.SelectAFieldFirst") + "\");\n    eval(\"editjob." + seqPrefix + "matchfield_\"+docclass+\".focus()\");\n    return;\n  }\n  if (eval(\"editjob." + seqPrefix + "matchtype_\"+docclass+\".value\") == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.SelectAMatchType") + "\");\n    eval(\"editjob." + seqPrefix + "matchtype_\"+docclass+\".focus()\");\n    return;\n  }\n\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "matchop_\"+docclass,\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddToken(anchorvalue)\n{\n  if (editjob." + seqPrefix + "spectoken.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "FilenetConnector.NullTokensNotAllowed") + "\");\n    editjob." + seqPrefix + "spectoken.focus();\n    return;\n  }\n\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "accessop\",\"Add\",anchorvalue);\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String pathDescription;
        int k;
        SpecificationNode sn;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        HashMap<String, DocClassSpec> documentClasses = new HashMap<String, DocClassSpec>();
        int i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals(SPEC_NODE_DOCUMENTCLASS)) continue;
            String value = sn.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            DocClassSpec spec = new DocClassSpec(sn);
            documentClasses.put(value, spec);
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.Folders")) && actualSequenceNumber == connectionSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals(SPEC_NODE_FOLDER)) continue;
                pathDescription = "_" + Integer.toString(k);
                String pathOpName = seqPrefix + "pathop" + (String)pathDescription;
                String startPath = sn.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
                out.print("  <tr>\n    <td class=\"value\">\n      <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FilenetConnector.Delete") + "\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.DeletePath") + Integer.toString(k) + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + pathOpName + "\",\"Delete\",\"" + seqPrefix + "path_" + Integer.toString(k) + "\")'/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specpath" + (String)pathDescription + "\" value=\"" + Encoder.attributeEscape((String)startPath) + "\"/>\n      <input type=\"hidden\" name=\"" + pathOpName + "\" value=\"\"/>\n      <nobr>" + (startPath.length() == 0 ? "(root)" : Encoder.bodyEscape((String)startPath)) + "</nobr>\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "FilenetConnector.NoFoldersChosen") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\" colspan=\"2\">\n      <nobr>\n        <input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n        <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n");
            String pathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpath"));
            if (pathSoFar == null) {
                pathSoFar = "/";
            }
            try {
                String[] childList = this.getChildFolders(pathSoFar);
                if (childList == null) {
                    pathSoFar = "/";
                    childList = this.getChildFolders("/");
                    if (childList == null) {
                        throw new ManifoldCFException("Can't find any children for root folder");
                    }
                }
                out.print("          <input type=\"hidden\" name=\"" + seqPrefix + "specpath\" value=\"" + Encoder.attributeEscape((String)pathSoFar) + "\"/>\n          <input type=\"hidden\" name=\"" + seqPrefix + "pathop\" value=\"\"/>\n          <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FilenetConnector.Add") + "\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.AddPath") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"pathop\",\"Add\",\"" + seqPrefix + "path_" + Integer.toString(k + 1) + "\")'/>\n          &nbsp;" + Encoder.bodyEscape((String)pathSoFar) + "\n");
                if (pathSoFar.length() > 0 && !pathSoFar.equals("/")) {
                    out.print("          <input type=\"button\" value=\"-\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.RemoveFromPath") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"pathop\",\"Up\",\"path_" + Integer.toString(k) + "\")'/>\n");
                }
                if (childList.length > 0) {
                    out.print("          <nobr>\n            <input type=\"button\" value=\"+\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.AddToPath") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToPath(\"" + seqPrefix + "path_" + Integer.toString(k) + "\")'/>&nbsp;\n            <select multiple=\"false\" name=\"" + seqPrefix + "pathaddon\" size=\"4\">\n              <option value=\"\" selected=\"selected\">-- " + Messages.getBodyString(locale, "FilenetConnector.PickAFolder") + " --</option>\n");
                    for (int j = 0; j < childList.length; ++j) {
                        String attrFolder = Encoder.attributeEscape((String)childList[j]);
                        String bodyFolder = Encoder.bodyEscape((String)childList[j]);
                        out.print("              <option value=\"" + attrFolder + "\">" + bodyFolder + "</option>\n");
                    }
                    out.print("            </select>\n          </nobr>\n");
                }
            }
            catch (ManifoldCFException e) {
                e.printStackTrace();
                out.println(Encoder.bodyEscape((String)e.getMessage()));
            }
            catch (ServiceInterruption e) {
                e.printStackTrace();
                out.println(Encoder.bodyEscape((String)("Transient error - " + e.getMessage())));
            }
            out.print("        </a>\n      </nobr>\n    </td>\n  </tr>\n</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals(SPEC_NODE_FOLDER)) continue;
                pathDescription = "_" + Integer.toString(k);
                String startPath = sn.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)startPath) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.DocumentClasses")) && actualSequenceNumber == connectionSequenceNumber) {
            String documentClass;
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "hasdocumentclasses\" value=\"true\"/>\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            DocumentClassDefinition[] documentClassArray = null;
            HashMap<String, MetadataFieldDefinition[]> documentClassFields = new HashMap<String, MetadataFieldDefinition[]>();
            Object message = null;
            try {
                documentClassArray = this.getDocumentClassesDetails();
                int j = 0;
                while (j < documentClassArray.length) {
                    documentClass = documentClassArray[j++].getSymbolicName();
                    MetadataFieldDefinition[] metaFields = this.getDocumentClassMetadataFieldsDetails(documentClass);
                    documentClassFields.put(documentClass, metaFields);
                }
            }
            catch (ManifoldCFException e) {
                message = e.getMessage();
            }
            catch (ServiceInterruption e) {
                message = "FileNet server temporarily unavailable: " + e.getMessage();
            }
            if (message != null) {
                out.print("  <tr><td class=\"message\" colspan=\"2\">" + Encoder.bodyEscape((String)message) + "</td></tr>\n");
            } else {
                i = 0;
                while (i < documentClassArray.length) {
                    String dName;
                    Object field;
                    int q;
                    int matchCount;
                    DocumentClassDefinition def = documentClassArray[i++];
                    documentClass = def.getSymbolicName();
                    String displayName = def.getDisplayName();
                    DocClassSpec spec = (DocClassSpec)documentClasses.get(documentClass);
                    out.print("  <tr>\n    <td class=\"description\">\n      <nobr>" + Encoder.bodyEscape((String)(documentClass + " (" + displayName + ")")) + ":</nobr>\n    </td>\n    <td class=\"boxcell\">\n      <table class=\"displaytable\">\n        <tr>\n          <td class=\"description\">\n            <nobr>" + Messages.getBodyString(locale, "FilenetConnector.Include") + "</nobr>\n          </td>\n          <td class=\"value\">\n            <nobr><input type=\"checkbox\" name=\"" + seqPrefix + "documentclasses\" " + (spec != null ? "checked=\"true\"" : "") + " value=\"" + Encoder.attributeEscape((String)documentClass) + "\"></input></nobr>\n          </td>\n        </tr>\n        <tr>\n          <td class=\"description\">\n            <nobr>" + Messages.getBodyString(locale, "FilenetConnector.DocumentCriteria") + "</nobr>\n          </td>\n          <td class=\"boxcell\">\n            <table class=\"displaytable\">\n");
                    MetadataFieldDefinition[] fields = (MetadataFieldDefinition[])documentClassFields.get(documentClass);
                    Object[] fieldArray = new String[fields.length];
                    HashMap<String, String> fieldMap = new HashMap<String, String>();
                    int j = 0;
                    while (j < fieldArray.length) {
                        MetadataFieldDefinition field2 = fields[j];
                        fieldArray[j++] = field2.getSymbolicName();
                        fieldMap.put(field2.getSymbolicName(), field2.getDisplayName());
                    }
                    Arrays.sort(fieldArray);
                    int n = matchCount = spec == null ? 0 : spec.getMatchCount();
                    for (q = 0; q < matchCount; ++q) {
                        String matchType = spec.getMatchType(q);
                        String matchField = spec.getMatchField(q);
                        String matchValue = spec.getMatchValue(q);
                        String opName = seqPrefix + "matchop_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q);
                        String labelName = seqPrefix + "match_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q);
                        out.print("              <tr>\n                <td class=\"description\">\n                  <input type=\"hidden\" name=\"" + opName + "\" value=\"\"/>\n                  <a name=\"" + labelName + "\">\n                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FilenetConnector.Delete") + "\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.Delete") + documentClass + " match # " + Integer.toString(q) + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + opName + "\",\"Delete\",\"" + labelName + "\")'/>\n                  </a>\n                </td>\n                <td class=\"value\">\n                  <input type=\"hidden\" name=\"" + seqPrefix + "matchfield_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q) + "\" value=\"" + Encoder.attributeEscape((String)matchField) + "\"/>\n                  <nobr>" + Encoder.bodyEscape((String)matchField) + "</nobr>\n                </td>\n                <td class=\"value\">\n                  <input type=\"hidden\" name=\"" + seqPrefix + "matchtype_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q) + "\" value=\"" + matchType + "\"/>\n                  <nobr>" + matchType + "</nobr>\n                </td>\n                <td class=\"value\">\n                  <input type=\"hidden\" name=\"" + seqPrefix + "matchvalue_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q) + "\" value=\"" + Encoder.attributeEscape((String)matchValue) + "\"/>\n                  <nobr>\"" + Encoder.bodyEscape((String)matchValue) + "\"</nobr>\n                </td>\n              </tr>\n");
                    }
                    if (q == 0) {
                        out.print("              <tr><td class=\"message\" colspan=\"4\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.NoCriteriaSpecified") + "</nobr></td></tr>\n");
                    }
                    String addLabelName = seqPrefix + "match_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q);
                    String addOpName = seqPrefix + "matchop_" + Encoder.attributeEscape((String)documentClass);
                    out.print("              <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n              <tr>\n                <td class=\"description\">\n                  <input type=\"hidden\" name=\"" + seqPrefix + "matchcount_" + Encoder.attributeEscape((String)documentClass) + "\" value=\"" + Integer.toString(matchCount) + "\"/>\n                  <input type=\"hidden\" name=\"" + addOpName + "\" value=\"\"/>\n                  <a name=\"" + addLabelName + "\">\n                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FilenetConnector.Add") + "\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.AddMatchFor") + Encoder.attributeEscape((String)documentClass) + "\" onClick='Javascript:" + seqPrefix + "SpecAddMatch(\"" + Encoder.attributeEscape((String)documentClass) + "\",\"" + seqPrefix + "match_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q + 1) + "\")'/>\n                  </a>\n                </td>\n                <td class=\"value\">\n                  <select name=\"" + seqPrefix + "matchfield_" + Encoder.attributeEscape((String)documentClass) + "\" size=\"5\">\n");
                    q = 0;
                    while (q < fieldArray.length) {
                        field = fieldArray[q++];
                        dName = (String)fieldMap.get(field);
                        out.print("                    <option value=\"" + Encoder.attributeEscape((String)field) + "\">" + Encoder.bodyEscape((String)((String)field + " (" + dName + ")")) + "</option>\n");
                    }
                    out.print("                  </select>\n                </td>\n                <td class=\"value\">\n                  <select name=\"" + seqPrefix + "matchtype_" + Encoder.attributeEscape((String)documentClass) + "\">\n                    <option value=\"=\">" + Messages.getBodyString(locale, "FilenetConnector.Equals") + "</option>\n                    <option value=\"!=\">" + Messages.getBodyString(locale, "FilenetConnector.NotEquals") + "</option>\n                    <option value=\"LIKE\">" + Messages.getBodyString(locale, "FilenetConnector.Like") + "</option>\n                  </select>\n                </td>\n                <td class=\"value\">\n                  <input name=\"" + seqPrefix + "matchvalue_" + Encoder.attributeEscape((String)documentClass) + "\" type=\"text\" size=\"32\" value=\"\"/>\n                </td>\n              </tr>\n            </table>\n          </td>\n        </tr>\n        <tr>\n          <td class=\"description\">\n            <nobr>" + Messages.getBodyString(locale, "FilenetConnector.IngestAllMetadataFields") + "</nobr>\n          </td>\n          <td class=\"value\">\n            <nobr><input type=\"checkbox\" name=\"" + seqPrefix + "allmetadata_" + Encoder.attributeEscape((String)documentClass) + "\" value=\"true\" " + (spec != null && spec.getAllMetadata() ? "checked=\"\"" : "") + "></input></nobr><br/>\n          </td>\n        </tr>\n        <tr>\n          <td class=\"description\">\n            <nobr>" + Messages.getBodyString(locale, "FilenetConnector.MetadataFields") + "</nobr>\n          </td>\n          <td class=\"value\">\n            <nobr>\n              <select name=\"" + seqPrefix + "metadatafield_" + Encoder.attributeEscape((String)documentClass) + "\" multiple=\"true\" size=\"5\">\n");
                    j = 0;
                    while (j < fieldArray.length) {
                        field = fieldArray[j++];
                        dName = (String)fieldMap.get(field);
                        out.print("                <option value=\"" + Encoder.attributeEscape((String)field) + "\" " + (spec != null && !spec.getAllMetadata() && spec.checkMetadataIncluded((String)field) ? "selected=\"true\"" : "") + ">" + Encoder.bodyEscape((String)((String)field + " (" + dName + ")")) + "</option>\n");
                    }
                    out.print("              </select>\n            </nobr>\n\n          </td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n");
                }
            }
            out.print("</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "hasdocumentclasses\" value=\"true\"/>\n");
            for (String documentClass : documentClasses.keySet()) {
                int q;
                DocClassSpec spec = (DocClassSpec)documentClasses.get(documentClass);
                if (spec.getAllMetadata()) {
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "allmetadata_" + Encoder.attributeEscape((String)documentClass) + "\" value=\"true\"/>\n");
                } else {
                    String[] metadataFields = spec.getMetadataFields();
                    q = 0;
                    while (q < metadataFields.length) {
                        String field = metadataFields[q++];
                        out.print("<input type=\"hidden\" name=\"" + seqPrefix + "metadatafield_" + Encoder.attributeEscape((String)documentClass) + "\" value=\"" + Encoder.attributeEscape((String)field) + "\"/>\n");
                    }
                }
                int matchCount = spec.getMatchCount();
                for (q = 0; q < matchCount; ++q) {
                    String matchType = spec.getMatchType(q);
                    String matchField = spec.getMatchField(q);
                    String matchValue = spec.getMatchValue(q);
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "matchfield_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q) + "\" value=\"" + Encoder.attributeEscape((String)matchField) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "matchtype_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q) + "\" value=\"" + matchType + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "matchvalue_" + Encoder.attributeEscape((String)documentClass) + "_" + Integer.toString(q) + "\" value=\"" + Encoder.attributeEscape((String)matchValue) + "\"/>\n");
                }
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "matchcount_" + Encoder.attributeEscape((String)documentClass) + "\" value=\"" + Integer.toString(matchCount) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "documentclasses\" value=\"" + Encoder.attributeEscape((String)documentClass) + "\"/>\n");
            }
        }
        HashMap<String, String> mimeTypes = null;
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn2;
            if (!(sn2 = ds.getChild(i++)).getType().equals(SPEC_NODE_MIMETYPE)) continue;
            String value = sn2.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            if (mimeTypes == null) {
                mimeTypes = new HashMap<String, String>();
            }
            mimeTypes.put(value, value);
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.MimeTypes")) && actualSequenceNumber == connectionSequenceNumber) {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "hasmimetypes\" value=\"true\"/>\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            String[] mimeTypesArray = null;
            Object message = null;
            try {
                mimeTypesArray = this.getMimeTypes();
            }
            catch (ManifoldCFException e) {
                message = e.getMessage();
            }
            catch (ServiceInterruption e) {
                message = "FileNet server temporarily unavailable: " + e.getMessage();
            }
            out.print("  <tr>\n");
            if (message != null) {
                out.print("    <td class=\"message\" colspan=\"2\">" + Encoder.bodyEscape((String)message) + "</td>\n");
            } else {
                out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.MimeTypesToInclude") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"" + seqPrefix + "mimetypes\" size=\"10\" multiple=\"true\">\n");
                i = 0;
                while (i < mimeTypesArray.length) {
                    String mimeType = mimeTypesArray[i++];
                    if (mimeTypes == null || mimeTypes.get(mimeType) != null) {
                        out.print("        <option value=\"" + Encoder.attributeEscape((String)mimeType) + "\" selected=\"true\">\n          " + Encoder.bodyEscape((String)mimeType) + "\n        </option>\n");
                        continue;
                    }
                    out.print("        <option value=\"" + Encoder.attributeEscape((String)mimeType) + "\">\n          " + Encoder.bodyEscape((String)mimeType) + "\n        </option>\n");
                }
                out.print("      </select>\n    </td>\n");
            }
            out.print("  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "hasmimetypes\" value=\"true\"/>\n");
            if (mimeTypes != null) {
                for (String mimeType : mimeTypes.keySet()) {
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "mimetypes\" value=\"" + Encoder.attributeEscape((String)mimeType) + "\"/>\n");
                }
            }
        }
        i = 0;
        boolean securityOn = true;
        while (i < ds.getChildCount()) {
            SpecificationNode sn3;
            if (!(sn3 = ds.getChild(i++)).getType().equals("security")) continue;
            String securityValue = sn3.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        if (tabName.equals(Messages.getString(locale, "FilenetConnector.Security")) && actualSequenceNumber == connectionSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.Security2") + "</nobr></td>\n    <td class=\"value\" colspan=\"1\">\n      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"on\" " + (securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "FilenetConnector.Enabled") + "      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"off\" " + (!securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "FilenetConnector.Disabled") + "    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn4;
                if (!(sn4 = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String token = sn4.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FilenetConnector.Delete") + "\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.DeleteAccessToken") + Integer.toString(k) + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")'/>\n      </a>\n    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)token) + "\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "FilenetConnector.NoAccessTokensPresent") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "FilenetConnector.Add") + "\" alt=\"" + Messages.getAttributeString(locale, "FilenetConnector.AddAccessToken") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")'/>\n      </a>\n    </td>\n    <td class=\"value\">\n      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specsecurity\" value=\"" + (securityOn ? "on" : "off") + "\"/>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn5;
                if (!(sn5 = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String token = sn5.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String op;
        String y;
        SpecificationNode node;
        String value;
        String[] x;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (variableContext.getParameter(seqPrefix + "hasdocumentclasses") != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                if (ds.getChild(i).getType().equals(SPEC_NODE_DOCUMENTCLASS)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            x = variableContext.getParameterValues(seqPrefix + "documentclasses");
            if (x != null) {
                i = 0;
                while (i < x.length) {
                    SpecificationNode matchNode;
                    String matchValue;
                    String matchField;
                    String matchType;
                    value = x[i++];
                    node = new SpecificationNode(SPEC_NODE_DOCUMENTCLASS);
                    node.setAttribute(SPEC_ATTRIBUTE_VALUE, value);
                    String allmetadata = variableContext.getParameter(seqPrefix + "allmetadata_" + value);
                    if (allmetadata == null) {
                        allmetadata = "false";
                    }
                    if (allmetadata.equals("true")) {
                        node.setAttribute(SPEC_ATTRIBUTE_ALLMETADATA, allmetadata);
                    } else {
                        String[] fields = variableContext.getParameterValues(seqPrefix + "metadatafield_" + value);
                        if (fields != null) {
                            int j = 0;
                            while (j < fields.length) {
                                String field = fields[j++];
                                SpecificationNode sp2 = new SpecificationNode(SPEC_NODE_METADATAFIELD);
                                sp2.setAttribute(SPEC_ATTRIBUTE_VALUE, field);
                                node.addChild(node.getChildCount(), (ConfigurationNode)sp2);
                            }
                        }
                    }
                    String matchCountString = variableContext.getParameter(seqPrefix + "matchcount_" + value);
                    int matchCount = Integer.parseInt(matchCountString);
                    for (int q = 0; q < matchCount; ++q) {
                        String matchOp = variableContext.getParameter(seqPrefix + "matchop_" + value + "_" + Integer.toString(q));
                        matchType = variableContext.getParameter(seqPrefix + "matchtype_" + value + "_" + Integer.toString(q));
                        matchField = variableContext.getParameter(seqPrefix + "matchfield_" + value + "_" + Integer.toString(q));
                        matchValue = variableContext.getParameter(seqPrefix + "matchvalue_" + value + "_" + Integer.toString(q));
                        if (matchOp != null && matchOp.equals("Delete")) continue;
                        matchNode = new SpecificationNode(SPEC_NODE_MATCH);
                        matchNode.setAttribute(SPEC_ATTRIBUTE_MATCHTYPE, matchType);
                        matchNode.setAttribute(SPEC_ATTRIBUTE_FIELDNAME, matchField);
                        if (matchValue == null) {
                            matchValue = "";
                        }
                        matchNode.setAttribute(SPEC_ATTRIBUTE_VALUE, matchValue);
                        node.addChild(node.getChildCount(), (ConfigurationNode)matchNode);
                    }
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                    String addMatchOp = variableContext.getParameter(seqPrefix + "matchop_" + value);
                    if (addMatchOp == null || !addMatchOp.equals("Add")) continue;
                    matchType = variableContext.getParameter(seqPrefix + "matchtype_" + value);
                    matchField = variableContext.getParameter(seqPrefix + "matchfield_" + value);
                    matchValue = variableContext.getParameter(seqPrefix + "matchvalue_" + value);
                    matchNode = new SpecificationNode(SPEC_NODE_MATCH);
                    matchNode.setAttribute(SPEC_ATTRIBUTE_MATCHTYPE, matchType);
                    matchNode.setAttribute(SPEC_ATTRIBUTE_FIELDNAME, matchField);
                    if (matchValue == null) {
                        matchValue = "";
                    }
                    matchNode.setAttribute(SPEC_ATTRIBUTE_VALUE, matchValue);
                    node.addChild(node.getChildCount(), (ConfigurationNode)matchNode);
                }
            }
        }
        if (variableContext.getParameter(seqPrefix + "hasmimetypes") != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                if (ds.getChild(i).getType().equals(SPEC_NODE_MIMETYPE)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            x = variableContext.getParameterValues(seqPrefix + "mimetypes");
            if (x != null) {
                i = 0;
                while (i < x.length) {
                    value = x[i++];
                    node = new SpecificationNode(SPEC_NODE_MIMETYPE);
                    node.setAttribute(SPEC_ATTRIBUTE_VALUE, value);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                }
            }
        }
        if ((y = variableContext.getParameter(seqPrefix + "pathcount")) != null) {
            Object path;
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals(SPEC_NODE_FOLDER)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int pathCount = Integer.parseInt(y);
            i = 0;
            while (i < pathCount) {
                String pathDescription = "_" + Integer.toString(i);
                String pathOpName = seqPrefix + "pathop" + pathDescription;
                y = variableContext.getParameter(pathOpName);
                if (y != null && y.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path2 = variableContext.getParameter(seqPrefix + "specpath" + pathDescription);
                SpecificationNode node2 = new SpecificationNode(SPEC_NODE_FOLDER);
                node2.setAttribute(SPEC_ATTRIBUTE_VALUE, path2);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "pathop");
            if (op != null && op.equals("Add")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                SpecificationNode node3 = new SpecificationNode(SPEC_NODE_FOLDER);
                node3.setAttribute(SPEC_ATTRIBUTE_VALUE, (String)path);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
            } else if (op != null && op.equals("Up")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                int k = ((String)path).lastIndexOf("/");
                path = k <= 0 ? "/" : ((String)path).substring(0, k);
                this.currentContext.save((Object)(seqPrefix + "specpath"), path);
            } else if (op != null && op.equals("AddToPath")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                String addon = variableContext.getParameter(seqPrefix + "pathaddon");
                if (addon != null && addon.length() > 0) {
                    path = ((String)path).length() <= 1 ? "/" + addon : (String)path + "/" + addon;
                }
                this.currentContext.save((Object)(seqPrefix + "specpath"), path);
            }
        }
        if ((y = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("security")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node4 = new SpecificationNode("security");
            node4.setAttribute(SPEC_ATTRIBUTE_VALUE, y);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node4);
        }
        if ((y = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(y);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                y = variableContext.getParameter(accessOpName);
                if (y != null && y.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node5 = new SpecificationNode("access");
                node5.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node5);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node6 = new SpecificationNode("access");
                node6.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node6);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n");
        HashMap<String, DocClassSpec> documentClasses = new HashMap<String, DocClassSpec>();
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals(SPEC_NODE_DOCUMENTCLASS)) continue;
            String value = sn.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            DocClassSpec spec = new DocClassSpec(sn);
            documentClasses.put(value, spec);
        }
        Object[] sortedDocumentClasses = new String[documentClasses.size()];
        i = 0;
        Iterator iter = documentClasses.keySet().iterator();
        while (iter.hasNext()) {
            sortedDocumentClasses[i++] = (String)iter.next();
        }
        Arrays.sort(sortedDocumentClasses);
        if (sortedDocumentClasses.length == 0) {
            out.print("    <td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.NoIncludedDocumentClasses") + "</nobr></td>\n");
        } else {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.IncludedDocumentClasses") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n");
            i = 0;
            while (i < sortedDocumentClasses.length) {
                int q;
                Object docclass = sortedDocumentClasses[i++];
                out.print("        <tr>\n          <td class=\"description\"><nobr>" + Encoder.bodyEscape((String)docclass) + "</nobr></td>\n          <td class=\"boxcell\">\n            <table class=\"displaytable\">\n              <tr>\n                <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.Metadata") + "</nobr></td>\n                <td class=\"value\">\n");
                DocClassSpec fieldValues = (DocClassSpec)documentClasses.get(docclass);
                if (fieldValues.getAllMetadata()) {
                    out.print("                  <nobr>(all metadata values)</nobr>\n");
                } else {
                    Object[] valuesList = fieldValues.getMetadataFields();
                    Arrays.sort(valuesList);
                    int j = 0;
                    while (j < valuesList.length) {
                        Object value = valuesList[j++];
                        out.print("                  <nobr>" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
                    }
                }
                out.print("                </td>\n              </tr>\n              <tr>\n                <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.DocumentsMatching") + "</nobr></td>\n                <td class=\"value\">\n");
                int matchCount = fieldValues.getMatchCount();
                for (q = 0; q < matchCount; ++q) {
                    String matchType = fieldValues.getMatchType(q);
                    String matchField = fieldValues.getMatchField(q);
                    String matchValue = fieldValues.getMatchValue(q);
                    out.print("                  <nobr>" + Encoder.bodyEscape((String)matchField) + " " + matchType + " \"" + Encoder.bodyEscape((String)matchValue) + "\"</nobr><br/>\n");
                }
                if (q == 0) {
                    out.print("                  <nobr>(" + Messages.getBodyString(locale, "FilenetConnector.AllDocumentsInClass") + "\"" + Encoder.bodyEscape((String)docclass) + "\")</nobr>\n");
                }
                out.print("                </td>\n              </tr>\n            </table>\n          </td>\n        </tr>\n");
            }
            out.print("      </table>\n    </td>\n");
        }
        out.print("  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n");
        i = 0;
        HashMap<String, String> mimeTypes = null;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals(SPEC_NODE_MIMETYPE)) continue;
            String value = sn.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            if (mimeTypes == null) {
                mimeTypes = new HashMap<String, String>();
            }
            mimeTypes.put(value, value);
        }
        if (mimeTypes != null) {
            Object[] sortedMimeTypes = new String[mimeTypes.size()];
            i = 0;
            iter = mimeTypes.keySet().iterator();
            while (iter.hasNext()) {
                sortedMimeTypes[i++] = (String)iter.next();
            }
            Arrays.sort(sortedMimeTypes);
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.IncludedMimeTypes") + "</nobr></td>\n    <td class=\"value\">\n");
            i = 0;
            while (i < sortedMimeTypes.length) {
                Object value = sortedMimeTypes[i++];
                out.print("      <nobr>" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
            }
            out.print("    </td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.NoIncludedMimeTypes") + "</nobr></td>\n");
        }
        out.print("  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            SpecificationNode spn;
            if (!(spn = ds.getChild(i++)).getType().equals(SPEC_NODE_FOLDER)) continue;
            if (!seenAny) {
                seenAny = true;
            }
            out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.Folders2") + "</nobr></td>\n    <td class=\"value\">\n      <nobr>" + Encoder.bodyEscape((String)spn.getAttributeValue(SPEC_ATTRIBUTE_VALUE)) + "</nobr>\n    </td>\n  </tr>\n");
        }
        if (!seenAny) {
            out.print("  <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "FilenetConnector.AllFoldersSpecified") + "</td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n");
        i = 0;
        boolean securityOn = true;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("security")) continue;
            String securityValue = sn.getAttributeValue(SPEC_ATTRIBUTE_VALUE);
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.Security2") + "</nobr></td>\n    <td class=\"value\">" + (securityOn ? "Enabled" : "Disabled") + "</td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "FilenetConnector.AccessTokens") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "FilenetConnector.NoAccessTokensSpecified") + "</td></tr>\n");
        }
        out.print("</table>\n");
    }

    public DocumentClassDefinition[] getDocumentClassesDetails() throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentClassesInfo();
        }
        catch (FilenetException e) {
            long currentTime = System.currentTimeMillis();
            if (e.getType() == 0) {
                throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public MetadataFieldDefinition[] getDocumentClassMetadataFieldsDetails(String documentClassName) throws ServiceInterruption, ManifoldCFException {
        try {
            return this.getDocumentClassMetadataFieldsInfo(documentClassName);
        }
        catch (FilenetException e) {
            long currentTime = System.currentTimeMillis();
            if (e.getType() == 0) {
                throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getMimeTypes() throws ManifoldCFException, ServiceInterruption {
        return new String[]{"application/excel", "application/powerpoint", "application/ppt", "application/rtf", "application/xls", "text/html", "text/rtf", "text/pdf", "application/x-excel", "application/x-msexcel", "application/x-mspowerpoint", "application/x-msword-doc", "application/x-msword", "application/x-word", "Application/pdf", "text/xml", "no-type", "text/plain", "application/pdf", "application/x-rtf", "application/vnd.ms-excel", "application/vnd.ms-pps", "application/vnd.ms-powerpoint", "application/vnd.ms-word", "application/msword", "application/msexcel", "application/mspowerpoint", "application/ms-powerpoint", "application/ms-word", "application/ms-excel", "Adobe", "application/Vnd.Ms-Excel", "vnd.ms-powerpoint", "application/x-pdf", "winword", "text/richtext", "Text", "Text/html", "application/MSWORD", "application/PDF", "application/MSEXCEL", "application/MSPOWERPOINT", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.text"};
    }

    protected static String convertToURI(String urlBase, String documentIdentifier, int elementNumber, String documentClass) {
        return urlBase + "&id=" + documentIdentifier + "&element=" + Integer.toString(elementNumber) + "&objectType=Document";
    }

    protected void checkConnection() throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            CheckConnectionThread t = new CheckConnectionThread();
            t.start();
            try {
                t.finishUp();
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected DocumentClassDefinition[] getDocumentClassesInfo() throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetDocumentClassesInfoThread t = new GetDocumentClassesInfoThread();
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected MetadataFieldDefinition[] getDocumentClassMetadataFieldsInfo(String documentClassName) throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetDocumentClassesMetadataFieldsInfoThread t = new GetDocumentClassesMetadataFieldsInfoThread(documentClassName);
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected String[] doGetChildFolders(String[] folderPath) throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetChildFoldersThread t = new GetChildFoldersThread(folderPath);
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected String[] doGetMatchingObjectIds(String sql) throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetMatchingObjectIdsThread t = new GetMatchingObjectIdsThread(sql);
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected Integer doGetDocumentContentCount(String documentIdentifier) throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetDocumentContentCountThread t = new GetDocumentContentCountThread(documentIdentifier);
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected FileInfo doGetDocumentInformation(String docId, Map<String, Object> metadataFields) throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetDocumentInformationThread t = new GetDocumentInformationThread(docId, metadataFields);
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected void doGetDocumentContents(String docId, int elementNumber, String tempFileName) throws FilenetException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetDocumentContentsThread t = new GetDocumentContentsThread(docId, elementNumber, tempFileName);
            t.start();
            try {
                t.finishUp();
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected static class SpecInfo {
        protected final Set<String> aclMap = new HashSet<String>();
        protected final boolean securityOn;
        protected final Map<String, DocClassSpec> docClassSpecs = new HashMap<String, DocClassSpec>();
        protected final Map<String, Object> metadataFields = new HashMap<String, Object>();

        public SpecInfo(Specification spec) {
            boolean securityOn = true;
            for (int i = 0; i < spec.getChildCount(); ++i) {
                String[] fields;
                String value;
                SpecificationNode sn = spec.getChild(i);
                if (sn.getType().equals("access")) {
                    String token = sn.getAttributeValue("token");
                    this.aclMap.add(token);
                    continue;
                }
                if (sn.getType().equals("security")) {
                    value = sn.getAttributeValue(FilenetConnector.SPEC_ATTRIBUTE_VALUE);
                    if (value.equals("on")) {
                        securityOn = true;
                        continue;
                    }
                    if (!value.equals("off")) continue;
                    securityOn = false;
                    continue;
                }
                if (!sn.getType().equals(FilenetConnector.SPEC_NODE_DOCUMENTCLASS)) continue;
                value = sn.getAttributeValue(FilenetConnector.SPEC_ATTRIBUTE_VALUE);
                DocClassSpec classSpec = new DocClassSpec(sn);
                this.docClassSpecs.put(value, classSpec);
                if (classSpec.getAllMetadata()) {
                    this.metadataFields.put(value, new Boolean(true));
                    continue;
                }
                HashSet<String> sumMap = new HashSet<String>();
                int j = 0;
                for (String field : fields = classSpec.getMetadataFields()) {
                    sumMap.add(field);
                }
                for (j = 0; j < classSpec.getMatchCount(); ++j) {
                    sumMap.add(classSpec.getMatchField(j));
                }
                String[] fieldArray = new String[sumMap.size()];
                j = 0;
                for (String field : sumMap) {
                    fieldArray[j++] = field;
                }
                this.metadataFields.put(value, fieldArray);
            }
            this.securityOn = securityOn;
        }

        public String[] getAcls() {
            if (!this.securityOn) {
                return null;
            }
            String[] rval = new String[this.aclMap.size()];
            int i = 0;
            for (String acl : this.aclMap) {
                rval[i++] = acl;
            }
            return rval;
        }

        public DocClassSpec getDocClassSpec(String docClass) {
            return this.docClassSpecs.get(docClass);
        }

        public Map<String, Object> getMetadataFields() {
            return this.metadataFields;
        }
    }

    protected class GetDocumentContentsThread
    extends Thread {
        protected final String docId;
        protected final int elementNumber;
        protected final String tempFileName;
        protected Throwable exception = null;

        public GetDocumentContentsThread(String docId, int elementNumber, String tempFileName) {
            this.setDaemon(true);
            this.docId = docId;
            this.elementNumber = elementNumber;
            this.tempFileName = tempFileName;
        }

        @Override
        public void run() {
            try {
                FilenetConnector.this.session.getDocumentContents(this.docId, this.elementNumber, this.tempFileName);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }

    protected class GetDocumentInformationThread
    extends Thread {
        protected final String docId;
        protected final Map<String, Object> metadataFields;
        protected FileInfo rval = null;
        protected Throwable exception = null;

        public GetDocumentInformationThread(String docId, Map<String, Object> metadataFields) {
            this.setDaemon(true);
            this.docId = docId;
            this.metadataFields = metadataFields;
        }

        @Override
        public void run() {
            try {
                this.rval = FilenetConnector.this.session.getDocumentInformation(this.docId, this.metadataFields);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public FileInfo finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetDocumentContentCountThread
    extends Thread {
        protected String identifier;
        protected Integer rval = null;
        protected Throwable exception = null;

        public GetDocumentContentCountThread(String identifier) {
            this.setDaemon(true);
            this.identifier = identifier;
        }

        @Override
        public void run() {
            try {
                this.rval = FilenetConnector.this.session.getDocumentContentCount(this.identifier);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Integer finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetMatchingObjectIdsThread
    extends Thread {
        protected String sql;
        protected String[] rval = null;
        protected Throwable exception = null;

        public GetMatchingObjectIdsThread(String sql) {
            this.setDaemon(true);
            this.sql = sql;
        }

        @Override
        public void run() {
            try {
                this.rval = FilenetConnector.this.session.getMatchingObjectIds(this.sql);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public String[] finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetChildFoldersThread
    extends Thread {
        protected final String[] folderPath;
        protected String[] rval = null;
        protected Throwable exception = null;

        public GetChildFoldersThread(String[] folderPath) {
            this.setDaemon(true);
            this.folderPath = folderPath;
        }

        @Override
        public void run() {
            try {
                this.rval = FilenetConnector.this.session.getChildFolders(this.folderPath);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public String[] finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetDocumentClassesMetadataFieldsInfoThread
    extends Thread {
        protected String documentClassName;
        protected MetadataFieldDefinition[] rval = null;
        protected Throwable exception = null;

        public GetDocumentClassesMetadataFieldsInfoThread(String documentClassName) {
            this.setDaemon(true);
            this.documentClassName = documentClassName;
        }

        @Override
        public void run() {
            try {
                this.rval = FilenetConnector.this.session.getDocumentClassMetadataFieldsDetails(this.documentClassName);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public MetadataFieldDefinition[] finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetDocumentClassesInfoThread
    extends Thread {
        protected DocumentClassDefinition[] rval = null;
        protected Throwable exception = null;

        public GetDocumentClassesInfoThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.rval = FilenetConnector.this.session.getDocumentClassesDetails();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public DocumentClassDefinition[] finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                FilenetConnector.this.session.checkConnection();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }

    protected class DestroySessionThread
    extends Thread {
        protected Throwable exception = null;

        public DestroySessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                FilenetConnector.this.session.destroySession();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected IFilenet rval = null;
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                IFilenetFactory df = (IFilenetFactory)Naming.lookup("rmi://127.0.0.1:8305/filenet_factory");
                IFilenet newSession = df.make();
                newSession.createSession(FilenetConnector.this.userID, FilenetConnector.this.password, FilenetConnector.this.filenetDomain, FilenetConnector.this.objectStore, FilenetConnector.this.serverWSIURI);
                FilenetConnector.this.session = newSession;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws MalformedURLException, NotBoundException, RemoteException, FilenetException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof MalformedURLException) {
                    throw (MalformedURLException)thr;
                }
                if (thr instanceof NotBoundException) {
                    throw (NotBoundException)thr;
                }
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof FilenetException) {
                    throw (FilenetException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }
}

