/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.scan;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.grid.impl.CoverageCSFactory;

public class FeatureScan {
    private String top;
    private boolean subdirs;
    private static final boolean debug = true;

    public FeatureScan(String top, boolean subdirs) {
        this.top = top;
        this.subdirs = subdirs;
    }

    public List<Bean> scan(Formatter errlog) {
        ArrayList<Bean> result = new ArrayList<Bean>();
        File topFile = new File(this.top);
        if (!topFile.exists()) {
            errlog.format("File %s does not exist", this.top);
            return result;
        }
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, result, errlog);
        } else {
            Bean fdb = new Bean(topFile);
            result.add(fdb);
        }
        return result;
    }

    private void scanDirectory(File dir, List<Bean> result, Formatter errlog) {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) continue;
            files.add(f);
        }
        if (files.size() > 0) {
            Collections.sort(files);
            ArrayList files2 = new ArrayList(files);
            File prev = null;
            for (File f : files) {
                String name = f.getName();
                String stem = this.stem(name);
                if (name.endsWith(".gbx") || name.endsWith(".gbx8") || name.endsWith(".pdf") || name.endsWith(".xml") || name.endsWith(".gbx9") || name.endsWith(".ncx") || name.endsWith(".txt") || name.endsWith(".tar")) {
                    files2.remove(f);
                } else if (prev != null) {
                    if (name.endsWith(".ncml")) {
                        if (prev.getName().equals(stem) || prev.getName().equals(stem + ".nc")) {
                            files2.remove(prev);
                        }
                    } else if (name.endsWith(".bz2")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gz")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gzip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".zip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".Z") && prev.getName().equals(stem)) {
                        files2.remove(f);
                    }
                }
                prev = f;
            }
            for (File f : files2) {
                result.add(new Bean(f));
            }
        }
        if (this.subdirs) {
            for (File f : dir.listFiles()) {
                if (!f.isDirectory() || f.getName().equals("exclude")) continue;
                this.scanDirectory(f, result, errlog);
            }
        }
    }

    private String stem(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public static void main(String[] arg) {
        String usage = "usage: ucar.nc2.ft.scan.FeatureScan directory [-subdirs]";
        if (arg.length < 1) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean subdirs = false;
        for (int i = 1; i < arg.length; ++i) {
            String s = arg[i];
            if (!s.equalsIgnoreCase("-subdirs")) continue;
            subdirs = true;
        }
        FeatureScan scanner = new FeatureScan(arg[0], subdirs);
        System.out.printf(" %-60s %-20s %-10s %-10s%n", "name", "fileType", "featureType", "featureImpl");
        List<Bean> beans = scanner.scan(new Formatter());
        for (Bean b : beans) {
            System.out.printf(" %-60s %-20s %-10s %-10s%n", b.getName(), b.getFileType(), b.getFeatureType(), b.getFeatureImpl());
        }
    }

    public class Bean {
        public File f;
        String fileType;
        String coordMap;
        FeatureType featureType;
        FeatureType ftFromMetadata;
        String ftype;
        StringBuilder info;
        String coordSysBuilder;
        String ftImpl;
        Throwable problem;
        String isCoverage;

        public Bean() {
            this.info = new StringBuilder();
        }

        public Bean(File f) {
            block18: {
                this.info = new StringBuilder();
                this.f = f;
                System.out.printf(" featureScan=%s%n", f.getPath());
                try (NetcdfDataset ds = NetcdfDataset.openDataset(f.getPath());){
                    this.fileType = ds.getFileTypeId();
                    this.setCoordMap(ds.getCoordinateSystems());
                    this.coordSysBuilder = ds.findAttValueIgnoreCase(null, "_CoordSysBuilder", "none");
                    Formatter errlog = new Formatter();
                    this.isCoverage = CoverageCSFactory.describe(errlog, ds);
                    this.info.append(errlog.toString());
                    this.ftFromMetadata = FeatureDatasetFactoryManager.findFeatureType(ds);
                    try {
                        errlog = new Formatter();
                        FeatureDataset featureDataset = FeatureDatasetFactoryManager.wrap(null, ds, null, errlog);
                        this.info.append("FeatureDatasetFactoryManager errlog = ");
                        this.info.append(errlog.toString());
                        this.info.append("\n\n");
                        if (featureDataset != null) {
                            this.featureType = featureDataset.getFeatureType();
                            if (this.featureType != null) {
                                this.ftype = this.featureType.toString();
                            }
                            this.ftImpl = featureDataset.getImplementationName();
                            Formatter infof = new Formatter();
                            featureDataset.getDetailInfo(infof);
                            this.info.append(infof.toString());
                            break block18;
                        }
                        this.ftype = "";
                    }
                    catch (Throwable t) {
                        this.ftype = " ERR: " + t.getMessage();
                        this.info.append(errlog.toString());
                        this.problem = t;
                    }
                }
                catch (Throwable t) {
                    this.fileType = " ERR: " + t.getMessage();
                    this.problem = t;
                }
            }
        }

        public String getName() {
            return this.f.getPath();
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getSizeK() {
            Formatter fm = new Formatter();
            fm.format("%,10d", this.f.length() / 1000L);
            return fm.toString();
        }

        public String getCoordMap() {
            return this.coordMap;
        }

        public String getCoordSysBuilder() {
            return this.coordSysBuilder;
        }

        public void setCoordMap(List<CoordinateSystem> csysList) {
            CoordinateSystem use = null;
            for (CoordinateSystem csys : csysList) {
                if (use == null) {
                    use = csys;
                    continue;
                }
                if (csys.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
                use = csys;
            }
            this.coordMap = use == null ? "" : "f:D(" + use.getRankDomain() + ")->R(" + use.getRankRange() + ")";
        }

        public String getFeatureType() {
            return this.ftype;
        }

        public String getFtMetadata() {
            return this.ftFromMetadata == null ? "" : this.ftFromMetadata.toString();
        }

        public String getFeatureImpl() {
            return this.ftImpl;
        }

        public String getCoverage() {
            return this.isCoverage == null ? "" : this.isCoverage;
        }

        public void toString(Formatter f, boolean showInfo) {
            f.format("%s%n %s%n map = '%s'%n %s%n %s%n", this.getName(), this.getFileType(), this.getCoordMap(), this.getFeatureType(), this.getFeatureImpl());
            if (showInfo && this.info != null) {
                f.format("%n%s", this.info);
            }
            if (this.problem != null) {
                StringWriter sw = new StringWriter(5000);
                this.problem.printStackTrace(new PrintWriter(sw));
                f.format(sw.toString(), new Object[0]);
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            this.toString(f, true);
            return f.toString();
        }

        public String runClassifier() {
            Formatter ff = new Formatter();
            String type = null;
            try (NetcdfDataset ds = NetcdfDataset.openDataset(this.f.getPath());){
                type = CoverageCSFactory.describe(ff, ds);
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                ff.format("%n%s", sw.toString());
            }
            ff.format("CoverageCS.Type = %s", type);
            return ff.toString();
        }
    }
}

