/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import ucar.nc2.grib.GribStatType;

public class Grib1WmoTimeType {
    public static GribStatType getStatType(int timeRangeIndicator) {
        switch (timeRangeIndicator) {
            case 3: 
            case 6: 
            case 7: 
            case 51: 
            case 113: 
            case 115: 
            case 117: 
            case 123: {
                return GribStatType.Average;
            }
            case 4: 
            case 114: 
            case 116: 
            case 124: {
                return GribStatType.Accumulation;
            }
            case 5: {
                return GribStatType.DifferenceFromEnd;
            }
            case 118: {
                return GribStatType.Covariance;
            }
            case 119: 
            case 125: {
                return GribStatType.StandardDeviation;
            }
        }
        return null;
    }

    public static String getTimeTypeName(int timeRangeIndicator) {
        String timeRange;
        switch (timeRangeIndicator) {
            case 0: {
                timeRange = "Uninitialized analysis / image product / forecast product valid for RT + P1";
                break;
            }
            case 1: {
                timeRange = "Initialized analysis product for reference time";
                break;
            }
            case 2: {
                timeRange = "product valid, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 3: {
                timeRange = "Average, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 4: {
                timeRange = "Accumulation, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 5: {
                timeRange = "Difference, interval = (RT + P2) - (RT + P1)";
                break;
            }
            case 6: {
                timeRange = "Average, interval = (RT - P1) to (RT - P2)";
                break;
            }
            case 7: {
                timeRange = "Average, interval = (RT - P1) to (RT + P2)";
                break;
            }
            case 10: {
                timeRange = "product valid at RT + P1";
                break;
            }
            case 51: {
                timeRange = "Climatological mean values from RT to (RT + P2)";
                break;
            }
            case 113: {
                timeRange = "Average of N forecasts, intervals = (refTime + i * P2, refTime + i * P2 + P1)";
                break;
            }
            case 114: {
                timeRange = "Accumulation of N forecasts, intervals = (refTime + i * P2, refTime + i * P2 + P1)";
                break;
            }
            case 115: {
                timeRange = "Average of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            case 116: {
                timeRange = "Accumulation of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            case 117: {
                timeRange = "Average of N forecasts, intervals = (refTime + i * P2, refTime + P1)";
                break;
            }
            case 118: {
                timeRange = "Temporal variance or covariance of N initialized analyses, timeCoord = (refTime + i * P2)";
                break;
            }
            case 119: {
                timeRange = "Standard Deviation of N forecasts, timeCoord = (refTime + P1 + i * P2)";
                break;
            }
            case 123: {
                timeRange = "Average of N uninitialized analyses, intervals = (refTime, refTime + i * P2)";
                break;
            }
            case 124: {
                timeRange = "Accumulation of N uninitialized analyses, intervals = (refTime, refTime + i * P2)";
                break;
            }
            case 125: {
                timeRange = "Standard deviation of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            default: {
                timeRange = "Unknown Time Range Indicator " + timeRangeIndicator;
            }
        }
        return timeRange;
    }
}

