/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import nbjavac.ServiceLoaderWrapper;

public class ModuleWrapper {
    private final Class<?> clazz;

    private ModuleWrapper(Class<?> c) {
        this.clazz = c;
    }

    public static ModuleWrapper getModule(Class<?> clazz) {
        return new ModuleWrapper(clazz);
    }

    public static ModuleWrapper getUnnamedModule(ClassLoader loader) {
        return new ModuleWrapper(null);
    }

    public String getName() {
        switch (this.clazz.getName()) {
            case "jdk.javadoc.internal.api.JavadocTool": {
                return "jdk.javadoc";
            }
            case "jpt.sun.tools.javac.api.JavacTool": {
                return "jdk.compiler";
            }
        }
        return "jdk.compiler";
    }

    public boolean isNamed() {
        return false;
    }

    public void addExports(String pack, ModuleWrapper to) {
    }

    public <S> void addUses(Class<S> service) {
        if (this.clazz != null) {
            ModuleWrapper.ensureUses(this.clazz, service);
        }
        ModuleWrapper.ensureUses(service);
    }

    static void ensureUses(Class<?> clazz) {
        Class<ServiceLoaderWrapper> thisClass = ServiceLoaderWrapper.class;
        ModuleWrapper.ensureUses(thisClass, clazz);
    }

    private static void ensureUses(Class<?> thisClass, Class<?> clazz) {
        try {
            Class<?> Module2 = Class.forName("java.lang.Module");
            Method addUses = Module2.getDeclaredMethod("addUses", Class.class);
            Method getModule = Class.class.getDeclaredMethod("getModule", new Class[0]);
            Object thisClassModule = getModule.invoke(thisClass, new Object[0]);
            addUses.invoke(thisClassModule, clazz);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            // empty catch block
        }
    }

    public static class ModuleDescriptor {

        public static class Version {
            public static void parse(String v) {
            }
        }
    }

    public static class Configuration {
        public Configuration resolveAndBind(ModuleFinder of, ModuleFinder finder, Set<?> emptySet) {
            return new Configuration();
        }
    }

    public static class ModuleLayer {
        public static ModuleLayer boot() {
            return new ModuleLayer();
        }

        public Configuration configuration() {
            return new Configuration();
        }

        public ModuleLayer defineModulesWithOneLoader(Configuration cf, ClassLoader systemClassLoader) {
            return new ModuleLayer();
        }

        public Set<ModuleWrapper> modules() {
            return Collections.emptySet();
        }
    }

    public static class ModuleFinder {
        public static ModuleFinder of(Path ... paths) {
            return new ModuleFinder();
        }
    }
}

