/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.nativeexecution.api.ui.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;
import org.netbeans.modules.nativeexecution.api.util.HostPropertyValidator;

/**
 *
 * @author ak119685
 */
public abstract class ValidateablePanel extends JPanel implements HostPropertyValidator{

    private final List<ValidatablePanelListener> listeners = new CopyOnWriteArrayList<>();

    public final void addValidationListener(ValidatablePanelListener listener) {
        if (listener == null) {
            return;
        }

        listeners.add(listener);
    }

    public final void removeValidationListener(ValidatablePanelListener listener) {
        if (listener == null) {
            return;
        }

        listeners.remove(listener);
    }

    public final void fireChange() {
        if (listeners.isEmpty()) {
            return;
        }

        for (ValidatablePanelListener listener : listeners) {
            listener.stateChanged(this);
        }
    }

    public abstract boolean hasProblem();

    public abstract String getProblem();

    public abstract void applyChanges(Object customData);
}
