/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.ExtensionClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.TagCountResult;

public class ListExtensionTags
extends AbstractNiFiRegistryCommand<TagCountResult> {
    public ListExtensionTags() {
        super("list-extension-tags", TagCountResult.class);
    }

    @Override
    public String getDescription() {
        return "Lists the tag counts for all extensions located in buckets the current user is authorized for.";
    }

    @Override
    public TagCountResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        ExtensionClient extensionClient = client.getExtensionClient();
        List tagCounts = extensionClient.getTagCounts();
        return new TagCountResult(this.getResultType(properties), tagCounts);
    }
}

