/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.apache.sis.util.ArgumentChecks;

public class FrequencySortedSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Comparator<E>,
Serializable {
    private static final long serialVersionUID = 6034102231354388179L;
    private final LinkedHashMap<E, Integer> count;
    private final int order;
    private transient E[] sorted;
    private transient int[] frequencies;
    private static final Comparator<Map.Entry<?, Integer>> COMPARATOR = (o1, o2) -> ((Integer)o1.getValue()).compareTo((Integer)o2.getValue());

    public FrequencySortedSet() {
        this.count = new LinkedHashMap();
        this.order = 0;
    }

    public FrequencySortedSet(boolean reversed) {
        this.count = new LinkedHashMap();
        this.order = reversed ? -1 : 0;
    }

    public FrequencySortedSet(int initialCapacity, boolean reversed) {
        this.count = new LinkedHashMap(initialCapacity);
        this.order = reversed ? -1 : 0;
    }

    @Override
    public int size() {
        return this.count.size();
    }

    @Override
    public boolean isEmpty() {
        return this.count.isEmpty();
    }

    public boolean add(E element, int occurrence) throws IllegalArgumentException {
        if (occurrence != 0) {
            ArgumentChecks.ensurePositive("occurrence", occurrence);
            this.sorted = null;
            return this.count.merge(element, occurrence ^= this.order, (old, n) -> Math.addExact(old, n) - this.order) == occurrence;
        }
        return false;
    }

    @Override
    public boolean add(E element) {
        return this.add(element, 1);
    }

    @Override
    public boolean contains(Object element) {
        return this.count.containsKey(element);
    }

    @Override
    public boolean remove(Object element) {
        if (this.count.remove(element) != null) {
            this.sorted = null;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.frequencies = null;
        this.sorted = null;
        this.count.clear();
    }

    @Override
    public Iterator<E> iterator() {
        this.ensureSorted();
        return new Iter(this.sorted, 0, this.sorted.length);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return new SubSet(false, null, true, toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return new SubSet(true, fromElement, false, null);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return new SubSet(true, fromElement, true, toElement);
    }

    @Override
    public E first() throws NoSuchElementException {
        this.ensureSorted();
        if (this.sorted.length != 0) {
            return this.sorted[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public E last() throws NoSuchElementException {
        this.ensureSorted();
        int length = this.sorted.length;
        if (length != 0) {
            return this.sorted[length - 1];
        }
        throw new NoSuchElementException();
    }

    private void ensureSorted() {
        if (this.sorted == null) {
            Map.Entry[] entries = (Map.Entry[])this.count.entrySet().toArray(Map.Entry[]::new);
            Arrays.sort(entries, COMPARATOR);
            int length = entries.length;
            this.sorted = new Object[length];
            if (this.frequencies == null || this.frequencies.length != length) {
                this.frequencies = new int[length];
            }
            for (int i = 0; i < length; ++i) {
                Map.Entry entry = entries[i];
                this.sorted[i] = entry.getKey();
                this.frequencies[i] = (Integer)entry.getValue() ^ this.order;
            }
        }
    }

    @Override
    public final Comparator<E> comparator() {
        return this;
    }

    @Override
    public final int compare(E o1, E o2) {
        return this.signedFrequency(o1) - this.signedFrequency(o2);
    }

    private int signedFrequency(E element) {
        Integer n = this.count.get(element);
        return n != null ? n : 0;
    }

    public int frequency(E element) {
        return this.signedFrequency(element) ^ this.order;
    }

    public int[] frequencies() {
        this.ensureSorted();
        return (int[])this.frequencies.clone();
    }

    @Override
    public Object[] toArray() {
        this.ensureSorted();
        return (Object[])this.sorted.clone();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.ensureSorted();
        if (array.length < this.sorted.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.sorted.length);
        }
        System.arraycopy(this.sorted, 0, array, 0, this.sorted.length);
        return array;
    }

    private final class Iter
    implements Iterator<E> {
        private final E[] elements;
        private final int lower;
        private final int upper;
        private int index;

        Iter(E[] sorted, int lower, int upper) {
            this.elements = sorted;
            this.index = lower;
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.upper;
        }

        @Override
        public E next() {
            if (this.index < this.upper) {
                return this.elements[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.index == this.lower || !FrequencySortedSet.this.remove(this.elements[this.index - 1])) {
                throw new IllegalStateException();
            }
        }
    }

    private final class SubSet
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 6843072153603161179L;
        private transient E[] elements;
        private final E fromElement;
        private final E toElement;
        private final boolean hasFrom;
        private final boolean hasTo;
        private transient int lower;
        private transient int upper;

        SubSet(boolean hasFrom, E fromElement, boolean hasTo, E toElement) {
            this.fromElement = fromElement;
            this.toElement = toElement;
            this.hasFrom = hasFrom;
            this.hasTo = hasTo;
        }

        @Override
        public Comparator<E> comparator() {
            return FrequencySortedSet.this;
        }

        private void ensureValidRange() {
            if (this.elements == null || this.elements != FrequencySortedSet.this.sorted) {
                FrequencySortedSet.this.ensureSorted();
                this.elements = FrequencySortedSet.this.sorted;
                if (this.hasFrom) {
                    this.lower = Arrays.binarySearch(this.elements, this.fromElement, FrequencySortedSet.this);
                    if (this.lower < 0) {
                        this.lower ^= 0xFFFFFFFF;
                    }
                }
                if (this.hasTo) {
                    this.upper = Arrays.binarySearch(this.elements, this.toElement, FrequencySortedSet.this);
                    if (this.upper < 0) {
                        this.upper ^= 0xFFFFFFFF;
                    }
                    if (this.upper < this.lower) {
                        this.upper = this.lower;
                    }
                } else {
                    this.upper = this.elements.length;
                }
            }
        }

        @Override
        public Iterator<E> iterator() {
            this.ensureValidRange();
            return new Iter(this.elements, this.lower, this.upper);
        }

        @Override
        public int size() {
            this.ensureValidRange();
            return this.upper - this.lower;
        }

        @Override
        public E first() {
            this.ensureValidRange();
            if (this.lower != this.upper) {
                return this.elements[this.lower];
            }
            throw new NoSuchElementException();
        }

        @Override
        public E last() {
            this.ensureValidRange();
            if (this.lower != this.upper) {
                return this.elements[this.upper - 1];
            }
            throw new NoSuchElementException();
        }

        @Override
        public SortedSet<E> headSet(E to) {
            return this.subSet(this.fromElement, to, this.hasFrom ? 0 : 2);
        }

        @Override
        public SortedSet<E> tailSet(E from) {
            return this.subSet(from, this.toElement, this.hasTo ? 0 : 1);
        }

        @Override
        public SortedSet<E> subSet(E from, E to) {
            return this.subSet(from, to, 0);
        }

        private SortedSet<E> subSet(E from, E to, int bounded) {
            if (this.hasFrom && FrequencySortedSet.this.compare(from, this.fromElement) < 0) {
                from = this.fromElement;
            }
            if (this.hasTo && FrequencySortedSet.this.compare(to, this.toElement) > 0) {
                to = this.toElement;
            }
            switch (bounded) {
                default: {
                    throw new AssertionError(bounded);
                }
                case 0: {
                    return FrequencySortedSet.this.subSet(from, to);
                }
                case 1: {
                    return FrequencySortedSet.this.tailSet(from);
                }
                case 2: 
            }
            return FrequencySortedSet.this.headSet(to);
        }
    }
}

