/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.lan;

import jakarta.xml.bind.annotation.XmlElement;
import java.util.Locale;
import org.apache.sis.xml.bind.lan.LocalisedCharacterString;

public final class TextGroup {
    @XmlElement(name="LocalisedCharacterString")
    public LocalisedCharacterString[] localized;

    public TextGroup() {
    }

    TextGroup(Locale locale, String text) {
        this.localized = new LocalisedCharacterString[]{new LocalisedCharacterString(locale, text)};
    }

    public String toString() {
        String lineSeparator = System.lineSeparator();
        StringBuilder buffer = new StringBuilder(160).append(this.getClass().getSimpleName()).append(lineSeparator);
        if (this.localized != null) {
            int corner = 0;
            for (LocalisedCharacterString string : this.localized) {
                corner = buffer.length();
                buffer.append("\u251c\u2500 ").append(string).append(lineSeparator);
            }
            if (corner != 0) {
                buffer.setCharAt(corner, '\u2514');
            }
        }
        return buffer.toString();
    }
}

