# v2.10 to 2.11

## initiatedBy added in Application CRD

In order to address [argoproj/argo-cd#16612](https://github.com/argoproj/argo-cd/issues/16612), initiatedBy has been added in the Application CRD.

## Egress NetworkPolicy for `argocd-redis` and `argocd-redis-ha-haproxy`

Starting with Argo CD 2.11.2, the NetworkPolicy for the `argocd-redis` and `argocd-redis-ha-haproxy` dropped Egress restrictions. This change was made
to allow access to the Kubernetes API to create a secret to secure Redis access.

To retain similar networking restrictions as before 2.11.2, you can add an Egress rule to allow access only to the
Kubernetes API and access needed by Redis itself. The Egress rule for Kubernetes access will depend entirely on your
Kubernetes setup. The access for Redis itself can be allowed by adding the following to the
`argocd-redis-network-policy` NetworkPolicy:

```diff
kind: NetworkPolicy
apiVersion: networking.k8s.io/v1
metadata:
  name: argocd-redis-network-policy
spec:
  policyTypes:
  - Ingress
+  - Egress
+  egress:
+  - ports:
+    - port: 53
+      protocol: UDP
+    - port: 53
+      protocol: TCP
```

```diff
kind: NetworkPolicy
apiVersion: networking.k8s.io/v1
metadata:
  name: argocd-redis-ha-haproxy
spec:
  policyTypes:
  - Ingress
+  - Egress
+  egress:
+  - ports:
+    - port: 6379
+      protocol: TCP
+    - port: 26379
+      protocol: TCP
+    to:
+    - podSelector:
+        matchLabels:
+          app.kubernetes.io/name: argocd-redis-ha
+  - ports:
+    - port: 53
+      protocol: UDP
+    - port: 53
+      protocol: TCP
```

## Sanitized project API response

Due to security reasons ([GHSA-786q-9hcg-v9ff](https://github.com/argoproj/argo-cd/security/advisories/GHSA-786q-9hcg-v9ff)),
the project API response was sanitized to remove sensitive information. This includes
credentials of project-scoped repositories and clusters.

> **Note:** The 2.11 series has been EOL for some time and has not received security updates. 2.11.14 was patched for critical 
> CVE-2025-55190 but was not patched for other vulnerabilities. It is important to upgrade to a supported version as quickly as possible.
