// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExponentialHistogram(t *testing.T) {
	src := &otlpmetrics.ExponentialHistogram{}
	dest := &otlpmetrics.ExponentialHistogram{}
	CopyOrigExponentialHistogram(dest, src)
	assert.Equal(t, &otlpmetrics.ExponentialHistogram{}, dest)
	FillOrigTestExponentialHistogram(src)
	CopyOrigExponentialHistogram(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExponentialHistogramUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.ExponentialHistogram{}
	UnmarshalJSONOrigExponentialHistogram(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.ExponentialHistogram{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExponentialHistogram(t *testing.T) {
	for name, src := range getEncodingTestValuesExponentialHistogram() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExponentialHistogram(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.ExponentialHistogram{}
			UnmarshalJSONOrigExponentialHistogram(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExponentialHistogram(t *testing.T) {
	for name, src := range getEncodingTestValuesExponentialHistogram() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExponentialHistogram(src))
			gotSize := MarshalProtoOrigExponentialHistogram(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.ExponentialHistogram{}
			require.NoError(t, UnmarshalProtoOrigExponentialHistogram(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExponentialHistogram() map[string]*otlpmetrics.ExponentialHistogram {
	return map[string]*otlpmetrics.ExponentialHistogram{
		"empty": {},
		"fill_test": func() *otlpmetrics.ExponentialHistogram {
			src := &otlpmetrics.ExponentialHistogram{}
			FillOrigTestExponentialHistogram(src)
			return src
		}(),
	}
}
