// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigGauge(dest, src *otlpmetrics.Gauge) {
	dest.DataPoints = CopyOrigNumberDataPointSlice(dest.DataPoints, src.DataPoints)
}

func FillOrigTestGauge(orig *otlpmetrics.Gauge) {
	orig.DataPoints = GenerateOrigTestNumberDataPointSlice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigGauge(orig *otlpmetrics.Gauge, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		MarshalJSONOrigNumberDataPoint(orig.DataPoints[0], dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			MarshalJSONOrigNumberDataPoint(orig.DataPoints[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigGauge unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigGauge(orig *otlpmetrics.Gauge, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "dataPoints", "data_points":
			orig.DataPoints = UnmarshalJSONOrigNumberDataPointSlice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigGauge(orig *otlpmetrics.Gauge) int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = SizeProtoOrigNumberDataPoint(orig.DataPoints[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigGauge(orig *otlpmetrics.Gauge, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = MarshalProtoOrigNumberDataPoint(orig.DataPoints[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigGauge(orig *otlpmetrics.Gauge, buf []byte) error {
	return orig.Unmarshal(buf)
}
