// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigHistogram(t *testing.T) {
	src := &otlpmetrics.Histogram{}
	dest := &otlpmetrics.Histogram{}
	CopyOrigHistogram(dest, src)
	assert.Equal(t, &otlpmetrics.Histogram{}, dest)
	FillOrigTestHistogram(src)
	CopyOrigHistogram(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigHistogramUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.Histogram{}
	UnmarshalJSONOrigHistogram(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.Histogram{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigHistogram(t *testing.T) {
	for name, src := range getEncodingTestValuesHistogram() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigHistogram(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.Histogram{}
			UnmarshalJSONOrigHistogram(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigHistogram(t *testing.T) {
	for name, src := range getEncodingTestValuesHistogram() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigHistogram(src))
			gotSize := MarshalProtoOrigHistogram(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.Histogram{}
			require.NoError(t, UnmarshalProtoOrigHistogram(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesHistogram() map[string]*otlpmetrics.Histogram {
	return map[string]*otlpmetrics.Histogram{
		"empty": {},
		"fill_test": func() *otlpmetrics.Histogram {
			src := &otlpmetrics.Histogram{}
			FillOrigTestHistogram(src)
			return src
		}(),
	}
}
