// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigHistogramDataPoint(t *testing.T) {
	src := &otlpmetrics.HistogramDataPoint{}
	dest := &otlpmetrics.HistogramDataPoint{}
	CopyOrigHistogramDataPoint(dest, src)
	assert.Equal(t, &otlpmetrics.HistogramDataPoint{}, dest)
	FillOrigTestHistogramDataPoint(src)
	CopyOrigHistogramDataPoint(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigHistogramDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.HistogramDataPoint{}
	UnmarshalJSONOrigHistogramDataPoint(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.HistogramDataPoint{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigHistogramDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigHistogramDataPoint(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.HistogramDataPoint{}
			UnmarshalJSONOrigHistogramDataPoint(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigHistogramDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigHistogramDataPoint(src))
			gotSize := MarshalProtoOrigHistogramDataPoint(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.HistogramDataPoint{}
			require.NoError(t, UnmarshalProtoOrigHistogramDataPoint(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesHistogramDataPoint() map[string]*otlpmetrics.HistogramDataPoint {
	return map[string]*otlpmetrics.HistogramDataPoint{
		"empty": {},
		"fill_test": func() *otlpmetrics.HistogramDataPoint {
			src := &otlpmetrics.HistogramDataPoint{}
			FillOrigTestHistogramDataPoint(src)
			return src
		}(),
		"default_sum": {Sum_: &otlpmetrics.HistogramDataPoint_Sum{Sum: float64(0)}},
		"default_min": {Min_: &otlpmetrics.HistogramDataPoint_Min{Min: float64(0)}},
		"default_max": {Max_: &otlpmetrics.HistogramDataPoint_Max{Max: float64(0)}},
	}
}
