// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigResourceProfiles(dest, src *otlpprofiles.ResourceProfiles) {
	CopyOrigResource(&dest.Resource, &src.Resource)
	dest.ScopeProfiles = CopyOrigScopeProfilesSlice(dest.ScopeProfiles, src.ScopeProfiles)
	dest.SchemaUrl = src.SchemaUrl
}

func FillOrigTestResourceProfiles(orig *otlpprofiles.ResourceProfiles) {
	FillOrigTestResource(&orig.Resource)
	orig.ScopeProfiles = GenerateOrigTestScopeProfilesSlice()
	orig.SchemaUrl = "test_schemaurl"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	MarshalJSONOrigResource(&orig.Resource, dest)
	if len(orig.ScopeProfiles) > 0 {
		dest.WriteObjectField("scopeProfiles")
		dest.WriteArrayStart()
		MarshalJSONOrigScopeProfiles(orig.ScopeProfiles[0], dest)
		for i := 1; i < len(orig.ScopeProfiles); i++ {
			dest.WriteMore()
			MarshalJSONOrigScopeProfiles(orig.ScopeProfiles[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigResourceProfiles unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "resource":
			UnmarshalJSONOrigResource(&orig.Resource, iter)
		case "scopeProfiles", "scope_profiles":
			orig.ScopeProfiles = UnmarshalJSONOrigScopeProfilesSlice(iter)
		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigResource(&orig.Resource)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeProfiles {
		l = SizeProtoOrigScopeProfiles(orig.ScopeProfiles[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigResource(&orig.Resource, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := range orig.ScopeProfiles {
		l = MarshalProtoOrigScopeProfiles(orig.ScopeProfiles[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, buf []byte) error {
	return orig.Unmarshal(buf)
}
