// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"

	"go.opentelemetry.io/collector/pdata/internal/data"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigSpan_Link(dest, src *otlptrace.Span_Link) {
	dest.TraceId = src.TraceId
	dest.SpanId = src.SpanId
	CopyOrigTraceState(&dest.TraceState, &src.TraceState)
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.Flags = src.Flags
}

func FillOrigTestSpan_Link(orig *otlptrace.Span_Link) {
	orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	FillOrigTestTraceState(&orig.TraceState)
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.DroppedAttributesCount = uint32(13)
	orig.Flags = uint32(13)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSpan_Link(orig *otlptrace.Span_Link, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TraceId != data.TraceID([16]byte{}) {
		dest.WriteObjectField("traceId")
		MarshalJSONOrigTraceID(&orig.TraceId, dest)
	}
	if orig.SpanId != data.SpanID([8]byte{}) {
		dest.WriteObjectField("spanId")
		MarshalJSONOrigSpanID(&orig.SpanId, dest)
	}
	if orig.TraceState != "" {
		dest.WriteObjectField("traceState")
		dest.WriteString(orig.TraceState)
	}
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSpanLink unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSpan_Link(orig *otlptrace.Span_Link, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "traceId", "trace_id":
			orig.TraceId.UnmarshalJSONIter(iter)
		case "spanId", "span_id":
			orig.SpanId.UnmarshalJSONIter(iter)
		case "traceState", "trace_state":
			UnmarshalJSONOrigTraceState(&orig.TraceState, iter)
		case "attributes":
			orig.Attributes = UnmarshalJSONOrigKeyValueSlice(iter)
		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "flags":
			orig.Flags = iter.ReadUint32()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigSpan_Link(orig *otlptrace.Span_Link) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigTraceID(&orig.TraceId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigSpanID(&orig.SpanId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = len(orig.TraceState)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	if orig.Flags != 0 {
		n += 5
	}
	return n
}

func MarshalProtoOrigSpan_Link(orig *otlptrace.Span_Link, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigTraceID(&orig.TraceId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	l = MarshalProtoOrigSpanID(&orig.SpanId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	l = len(orig.TraceState)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.TraceState)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := range orig.Attributes {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x22
	}
	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x28
	}
	if orig.Flags != 0 {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.Flags))
		pos--
		buf[pos] = 0x35
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSpan_Link(orig *otlptrace.Span_Link, buf []byte) error {
	return orig.Unmarshal(buf)
}
