// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigSum(dest, src *otlpmetrics.Sum) {
	dest.DataPoints = CopyOrigNumberDataPointSlice(dest.DataPoints, src.DataPoints)
	dest.AggregationTemporality = src.AggregationTemporality
	dest.IsMonotonic = src.IsMonotonic
}

func FillOrigTestSum(orig *otlpmetrics.Sum) {
	orig.DataPoints = GenerateOrigTestNumberDataPointSlice()
	orig.AggregationTemporality = otlpmetrics.AggregationTemporality(1)
	orig.IsMonotonic = true
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSum(orig *otlpmetrics.Sum, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		MarshalJSONOrigNumberDataPoint(orig.DataPoints[0], dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			MarshalJSONOrigNumberDataPoint(orig.DataPoints[i], dest)
		}
		dest.WriteArrayEnd()
	}

	if int32(orig.AggregationTemporality) != 0 {
		dest.WriteObjectField("aggregationTemporality")
		dest.WriteInt32(int32(orig.AggregationTemporality))
	}
	if orig.IsMonotonic != false {
		dest.WriteObjectField("isMonotonic")
		dest.WriteBool(orig.IsMonotonic)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSum unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSum(orig *otlpmetrics.Sum, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "dataPoints", "data_points":
			orig.DataPoints = UnmarshalJSONOrigNumberDataPointSlice(iter)
		case "aggregationTemporality", "aggregation_temporality":
			orig.AggregationTemporality = otlpmetrics.AggregationTemporality(iter.ReadEnumValue(otlpmetrics.AggregationTemporality_value))
		case "isMonotonic", "is_monotonic":
			orig.IsMonotonic = iter.ReadBool()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigSum(orig *otlpmetrics.Sum) int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = SizeProtoOrigNumberDataPoint(orig.DataPoints[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.AggregationTemporality != 0 {
		n += 1 + proto.Sov(uint64(orig.AggregationTemporality))
	}
	if orig.IsMonotonic {
		n += 2
	}
	return n
}

func MarshalProtoOrigSum(orig *otlpmetrics.Sum, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = MarshalProtoOrigNumberDataPoint(orig.DataPoints[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.AggregationTemporality != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AggregationTemporality))
		pos--
		buf[pos] = 0x10
	}
	if orig.IsMonotonic {
		pos--
		if orig.IsMonotonic {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSum(orig *otlpmetrics.Sum, buf []byte) error {
	return orig.Unmarshal(buf)
}
