// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"math"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigSummaryDataPoint_ValueAtQuantile(dest, src *otlpmetrics.SummaryDataPoint_ValueAtQuantile) {
	dest.Quantile = src.Quantile
	dest.Value = src.Value
}

func FillOrigTestSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile) {
	orig.Quantile = float64(3.1415926)
	orig.Value = float64(3.1415926)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Quantile != float64(0) {
		dest.WriteObjectField("quantile")
		dest.WriteFloat64(orig.Quantile)
	}
	if orig.Value != float64(0) {
		dest.WriteObjectField("value")
		dest.WriteFloat64(orig.Value)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSummaryDataPointValueAtQuantile unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "quantile":
			orig.Quantile = iter.ReadFloat64()
		case "value":
			orig.Value = iter.ReadFloat64()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile) int {
	var n int
	var l int
	_ = l
	if orig.Quantile != 0 {
		n += 9
	}
	if orig.Value != 0 {
		n += 9
	}
	return n
}

func MarshalProtoOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.Quantile != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Quantile))
		pos--
		buf[pos] = 0x9
	}
	if orig.Value != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Value))
		pos--
		buf[pos] = 0x11
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, buf []byte) error {
	return orig.Unmarshal(buf)
}
