// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
)

func TestTraces_MoveTo(t *testing.T) {
	ms := generateTestTraces()
	dest := NewTraces()
	ms.MoveTo(dest)
	assert.Equal(t, NewTraces(), ms)
	assert.Equal(t, generateTestTraces(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestTraces(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newTraces(&otlpcollectortrace.ExportTraceServiceRequest{}, &sharedState)) })
	assert.Panics(t, func() { newTraces(&otlpcollectortrace.ExportTraceServiceRequest{}, &sharedState).MoveTo(dest) })
}

func TestTraces_CopyTo(t *testing.T) {
	ms := NewTraces()
	orig := NewTraces()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestTraces()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newTraces(&otlpcollectortrace.ExportTraceServiceRequest{}, &sharedState)) })
}

func TestTraces_ResourceSpans(t *testing.T) {
	ms := NewTraces()
	assert.Equal(t, NewResourceSpansSlice(), ms.ResourceSpans())
	ms.getOrig().ResourceSpans = internal.GenerateOrigTestResourceSpansSlice()
	assert.Equal(t, generateTestResourceSpansSlice(), ms.ResourceSpans())
}

func generateTestTraces() Traces {
	return Traces(internal.GenerateTestTraces())
}
