// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

func TestCopyOrigAnyValueSlice(t *testing.T) {
	src := []otlpcommon.AnyValue{}
	dest := []otlpcommon.AnyValue{}
	// Test CopyTo empty
	dest = CopyOrigAnyValueSlice(dest, src)
	assert.Equal(t, []otlpcommon.AnyValue{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestAnyValueSlice()
	dest = CopyOrigAnyValueSlice(dest, src)
	assert.Equal(t, GenerateOrigTestAnyValueSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigAnyValueSlice(dest, src)
	assert.Equal(t, GenerateOrigTestAnyValueSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigAnyValueSlice(dest, []otlpcommon.AnyValue{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigAnyValueSlice(dest, src)
	assert.Equal(t, GenerateOrigTestAnyValueSlice(), dest)
}
