// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyProfilesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewProfilesRequest()
				CopyProfilesRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyProfilesRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyProfilesRequestSlice(t *testing.T) {
	src := []ProfilesRequest{}
	dest := []ProfilesRequest{}
	// Test CopyTo empty
	dest = CopyProfilesRequestSlice(dest, src)
	assert.Equal(t, []ProfilesRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfilesRequestSlice()
	dest = CopyProfilesRequestSlice(dest, src)
	assert.Equal(t, GenTestProfilesRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfilesRequestSlice(dest, src)
	assert.Equal(t, GenTestProfilesRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfilesRequestSlice(dest, []ProfilesRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfilesRequestSlice(dest, src)
	assert.Equal(t, GenTestProfilesRequestSlice(), dest)
}

func TestCopyProfilesRequestPtrSlice(t *testing.T) {
	src := []*ProfilesRequest{}
	dest := []*ProfilesRequest{}
	// Test CopyTo empty
	dest = CopyProfilesRequestPtrSlice(dest, src)
	assert.Equal(t, []*ProfilesRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfilesRequestPtrSlice()
	dest = CopyProfilesRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfilesRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfilesRequestPtrSlice(dest, []*ProfilesRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfilesRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONProfilesRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewProfilesRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewProfilesRequest(), dest)
}

func TestMarshalAndUnmarshalJSONProfilesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewProfilesRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteProfilesRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoProfilesRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesProfilesRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewProfilesRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoProfilesRequestUnknown(t *testing.T) {
	dest := NewProfilesRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewProfilesRequest(), dest)
}

func TestMarshalAndUnmarshalProtoProfilesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewProfilesRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteProfilesRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufProfilesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewProfilesRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesProfilesRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"RequestContext/wrong_wire_type": {0x14},
		"RequestContext/missing_value":   {0x12},
		"ProfilesData/wrong_wire_type":   {0x1c},
		"ProfilesData/missing_value":     {0x1a},
		"FormatVersion/wrong_wire_type":  {0xc},
		"FormatVersion/missing_value":    {0xd},
	}
}

func genTestEncodingValuesProfilesRequest() map[string]*ProfilesRequest {
	return map[string]*ProfilesRequest{
		"empty":               NewProfilesRequest(),
		"RequestContext/test": {RequestContext: GenTestRequestContext()},
		"ProfilesData/test":   {ProfilesData: *GenTestProfilesData()},
		"FormatVersion/test":  {FormatVersion: uint32(13)},
	}
}
