/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.CachingPageStorageWrapper;
import com.sun.electric.database.geometry.btree.FilePageStorage;
import com.sun.electric.database.geometry.btree.MemoryPageStorage;
import com.sun.electric.database.geometry.btree.OverflowPageStorage;
import com.sun.electric.database.geometry.btree.unboxed.AssociativeCommutativeOperation;
import com.sun.electric.database.geometry.btree.unboxed.LatticeOperation;
import com.sun.electric.database.geometry.btree.unboxed.Pair;
import com.sun.electric.database.geometry.btree.unboxed.Unboxed;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedHalfDouble;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedPair;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BTreeSignal<S extends Sample>
extends MutableSignal<S> {
    private Signal.View<S> exactView = null;
    private final BTree<Double, S, Pair<S, S>> tree;
    private double minTime = Double.MAX_VALUE;
    private double maxTime = -1.7976931348623157E308;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = -1.7976931348623157E308;
    public static int misses = 0;
    public static int steps = 0;
    public static int numLookups = 0;
    private static CachingPageStorage ps = null;

    public BTreeSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, boolean digital, BTree<Double, S, Pair<S, S>> tree) {
        super(sc, sd, signalName, signalContext, digital);
        if (tree == null) {
            throw new RuntimeException();
        }
        this.tree = tree;
        this.exactView = new Signal.View<S>(){

            @Override
            public int getNumEvents() {
                return BTreeSignal.this.tree.size();
            }

            @Override
            public double getTime(int index2) {
                Double d = (Double)BTreeSignal.this.tree.getKeyFromOrd(index2);
                if (d == null) {
                    throw new RuntimeException("Entry " + index2 + " not valid (tree size is " + BTreeSignal.this.tree.size() + ")");
                }
                return d;
            }

            @Override
            public S getSample(int index2) {
                Sample ret = (Sample)BTreeSignal.this.tree.getValFromOrd(index2);
                if (ret == null) {
                    throw new RuntimeException("Entry " + index2 + " not valid (tree size is " + BTreeSignal.this.tree.size() + ")");
                }
                return ret;
            }
        };
    }

    @Override
    public S getSample(double time) {
        return (S)((Sample)this.tree.getValFromKey(new Double(time)));
    }

    @Override
    public void addSample(double time, S sample) {
        this.tree.insert(new Double(time), sample);
        this.minTime = Math.min(this.minTime, time);
        this.maxTime = Math.max(this.maxTime, time);
        this.minValue = Math.min(this.minValue, sample.getMinValue());
        this.maxValue = Math.max(this.maxValue, sample.getMaxValue());
    }

    @Override
    public void replaceSample(double time, S sample) {
        this.tree.replace(new Double(time), sample);
        this.minTime = Math.min(this.minTime, time);
        this.maxTime = Math.max(this.maxTime, time);
        this.minValue = Math.min(this.minValue, sample.getMinValue());
        this.maxValue = Math.max(this.maxValue, sample.getMaxValue());
    }

    @Override
    public Signal.View<S> getExactView() {
        return this.exactView;
    }

    @Override
    public Signal.View<RangeSample<S>> getRasterView(double t0, double t1, int numPixels) {
        return new BTreeRasterView(t0, t1, numPixels);
    }

    @Override
    public boolean isEmpty() {
        return this.tree.size() == 0;
    }

    @Override
    public double getMinTime() {
        return this.minTime;
    }

    @Override
    public double getMaxTime() {
        return this.maxTime;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    protected Pair<S, S> getSummaryFromKeys(Double t1, Double t2) {
        return this.tree.getSummaryFromKeys(t1, t2);
    }

    static <SS extends Sample> BTree<Double, SS, Pair<SS, SS>> getTree(Unboxed<SS> unboxer, LatticeOperation<SS> latticeOp) {
        if (ps == null) {
            try {
                long highWaterMarkInBytes = 0x3200000L;
                FilePageStorage fps = FilePageStorage.create();
                OverflowPageStorage ops2 = new OverflowPageStorage(new MemoryPageStorage(fps.getPageSize()), fps, highWaterMarkInBytes);
                ps = new CachingPageStorageWrapper(ops2, 16384, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new BTree(ps, UnboxedHalfDouble.instance, unboxer, new Summary<SS>(UnboxedHalfDouble.instance, unboxer, latticeOp));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Summary<SS extends Sample>
    extends UnboxedPair<SS, SS>
    implements BTree.Summary<Double, SS, Pair<SS, SS>>,
    AssociativeCommutativeOperation<Pair<SS, SS>> {
        private final LatticeOperation<SS> latticeOp;
        private final Unboxed<Double> uk;
        private final Unboxed<SS> uv;

        public Summary(Unboxed<Double> uk, Unboxed<SS> uv, LatticeOperation<SS> latticeOp) {
            super(uv, uv);
            this.uk = uk;
            this.uv = uv;
            this.latticeOp = latticeOp;
        }

        @Override
        public void call(byte[] buf_arg, int ofs_arg, byte[] buf_result, int ofs_result) {
            System.arraycopy(buf_arg, ofs_arg + this.uk.getSize(), buf_result, ofs_result, this.uv.getSize());
            System.arraycopy(buf_arg, ofs_arg + this.uk.getSize(), buf_result, ofs_result + this.uv.getSize(), this.uv.getSize());
        }

        @Override
        public void multiply(byte[] buf1, int ofs1, byte[] buf2, int ofs2, byte[] buf_dest, int ofs_dest) {
            this.latticeOp.glb(buf1, ofs1, buf2, ofs2, buf_dest, ofs_dest);
            this.latticeOp.lub(buf1, ofs1 + this.uv.getSize(), buf2, ofs2 + this.uv.getSize(), buf_dest, ofs_dest + this.uv.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BTreeRasterView
    implements Signal.View<RangeSample<S>> {
        private final double t0;
        private final double t1;
        private final int numRegions;
        private final boolean exact;
        private int t0_ord;
        private int t1_ord;

        public BTreeRasterView(double t0, double t1, int numRegions) {
            Double t0_ = new Double(Math.min(t0, t1));
            Double t1_ = new Double(Math.max(t0, t1));
            this.t0_ord = BTreeSignal.this.tree.getOrdFromKeyFloor(t0_);
            this.t1_ord = BTreeSignal.this.tree.getOrdFromKeyFloor(t1_);
            t0_ = (Double)BTreeSignal.this.tree.getKeyFromOrd(this.t0_ord);
            this.t1_ord = Math.min(BTreeSignal.this.tree.size() - 1, this.t1_ord + 1);
            t1_ = (Double)BTreeSignal.this.tree.getKeyFromOrd(this.t1_ord);
            this.t0_ord = Math.max(this.t0_ord, 0);
            this.t1_ord = Math.min(this.t1_ord, BTreeSignal.this.tree.size() - 1);
            this.t0 = t0_;
            this.t1 = t1_;
            int actualNumSamples = this.t1_ord - this.t0_ord + 1;
            if (actualNumSamples > numRegions && (double)actualNumSamples * 0.75 < (double)numRegions) {
                numRegions = actualNumSamples + 1;
            }
            this.exact = numRegions > actualNumSamples;
            this.numRegions = this.exact ? actualNumSamples : numRegions;
        }

        @Override
        public int getNumEvents() {
            return this.numRegions;
        }

        @Override
        public double getTime(int index2) {
            if (index2 < 0) {
                throw new RuntimeException("ERROR: getTime() called with negative number");
            }
            if (index2 >= this.getNumEvents()) {
                throw new RuntimeException("ERROR: getTime() called with number greater than or equal to getNumEvents()");
            }
            if (!this.exact) {
                return this.t0 + (this.t1 - this.t0) * (double)index2 / (double)this.numRegions;
            }
            Double ret = (Double)BTreeSignal.this.tree.getKeyFromOrd(this.t0_ord + index2);
            if (ret == null) {
                throw new RuntimeException("ERROR: sample not found in BTree -- this should not happen; t0_ord=" + this.t0_ord + " t1_ord=" + this.t1_ord + " exact=" + this.exact + " index=" + index2 + " tree.size()=" + BTreeSignal.this.tree.size() + " numRegions=" + this.numRegions);
            }
            return ret;
        }

        @Override
        public RangeSample<S> getSample(int index2) {
            if (index2 >= this.getNumEvents() - 1) {
                Sample sample = (Sample)BTreeSignal.this.tree.getValFromOrd(this.t1_ord);
                return sample == null ? null : new RangeSample<Sample>(sample, sample);
            }
            if (this.exact) {
                Sample sample = (Sample)BTreeSignal.this.tree.getValFromOrd(this.t0_ord + index2);
                return sample == null ? null : new RangeSample<Sample>(sample, sample);
            }
            Double tfirst = new Double(this.getTime(index2));
            Double tsecond = new Double(this.getTime(index2 + 1));
            if (tfirst.doubleValue() == tsecond.doubleValue()) {
                Sample sample = (Sample)BTreeSignal.this.tree.getValFromKey(tfirst);
                return sample == null ? null : new RangeSample<Sample>(sample, sample);
            }
            Pair highlow = (Pair)BTreeSignal.this.tree.getSummaryFromKeys(tfirst, tsecond);
            return highlow == null ? null : new RangeSample<Sample>((Sample)highlow.getKey(), (Sample)highlow.getValue());
        }
    }
}

