/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.expr.Language;
import gnu.kawa.servlet.MyTtyInPort;
import gnu.kawa.servlet.OutBufferWriter;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.InPort;
import gnu.text.Path;
import gnu.text.QueueReader;
import java.io.Writer;
import kawa.repl;
import kawa.standard.Scheme;

public class ReplSession
extends Writer {
    Language language;
    Environment penvironment;
    QueueReader qreader;
    InPort in_p;
    OutBufferWriter err_p;
    OutBufferWriter out_p;
    OutBufferWriter prompt_p;
    Future thread;
    StringBuffer outBuffer = new StringBuffer();
    boolean outAvailable;

    void append1(char c) {
        if (c == '\r' || c == '\n') {
            this.outBuffer.append("<br/>");
        } else {
            this.outBuffer.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        ReplSession replSession = this;
        synchronized (replSession) {
            this.append1((char)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) {
        ReplSession replSession = this;
        synchronized (replSession) {
            for (int i = 0; i < len; ++i) {
                this.append1(cbuf[off + i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int off, int len) {
        ReplSession replSession = this;
        synchronized (replSession) {
            for (int i = 0; i < len; ++i) {
                this.append1(str.charAt(off + i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ReplSession replSession = this;
        synchronized (replSession) {
            if (this.outBuffer.length() > 0) {
                this.outAvailable = true;
            }
            this.notify();
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String grabOutput() {
        ReplSession replSession = this;
        synchronized (replSession) {
            return this.grabOutputRaw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String waitOutput() {
        ReplSession replSession = this;
        synchronized (replSession) {
            if (!this.outAvailable) {
                try {
                    this.wait(30000L);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            String out = this.grabOutputRaw();
            return out;
        }
    }

    String grabOutputRaw() {
        String result = this.outBuffer.toString();
        this.outBuffer.setLength(0);
        this.outAvailable = false;
        return result;
    }

    public ReplSession() {
        this(Scheme.getInstance());
    }

    public ReplSession(Language language) {
        if (Language.getDefaultLanguage() == null) {
            Language.setDefaults(language);
        }
        this.penvironment = Environment.getCurrent();
        this.qreader = new QueueReader();
        this.out_p = new OutBufferWriter(this, 'O', Path.valueOf("/dev/stdout"));
        this.err_p = new OutBufferWriter(this, 'E', Path.valueOf("/dev/stderr>"));
        this.prompt_p = new OutBufferWriter(this, 'P', Path.valueOf("/dev/prompt"));
        this.in_p = new MyTtyInPort(this.qreader, Path.valueOf("/dev/stdin"), this.out_p, this);
        this.thread = Future.make(new repl(language), this.penvironment, this.in_p, this.out_p, this.err_p);
        this.thread.start();
    }

    void appendInputLine(String line) {
        this.qreader.append(line, 0, line.length());
        this.qreader.append('\n');
    }

    void appendInput(String line) {
        this.qreader.append(line, 0, line.length());
    }
}

