/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.ElementPredicate;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.SubSequence;
import gnu.lists.TreePosition;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractSequence {
    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int rank() {
        return 1;
    }

    public abstract Object get(int var1);

    public int getEffectiveIndex(int[] indexes) {
        return indexes[0];
    }

    public Object get(int[] indexes) {
        return this.get(indexes[0]);
    }

    public Object set(int[] indexes, Object value) {
        return this.set(indexes[0], value);
    }

    public int getLowBound(int dim) {
        return 0;
    }

    public int getSize(int dim) {
        return dim == 0 ? this.size() : 1;
    }

    protected RuntimeException unsupported(String text) {
        return AbstractSequence.unsupportedException(this.getClass().getName() + " does not implement " + text);
    }

    public static RuntimeException unsupportedException(String text) {
        return new UnsupportedOperationException(text);
    }

    public Object set(int index, Object element) {
        throw this.unsupported("set");
    }

    public void fill(Object value) {
        int i = this.startPos();
        while ((i = this.nextPos(i)) != 0) {
            this.setPosPrevious(i, value);
        }
    }

    public void fillPosRange(int fromPos, int toPos, Object value) {
        int i = this.copyPos(fromPos);
        while (this.compare(i, toPos) < 0) {
            this.setPosNext(i, value);
            i = this.nextPos(i);
        }
        this.releasePos(i);
    }

    public void fill(int fromIndex, int toIndex, Object value) {
        int i = this.createPos(fromIndex, false);
        int limit = this.createPos(toIndex, true);
        while (this.compare(i, limit) < 0) {
            this.setPosNext(i, value);
            i = this.nextPos(i);
        }
        this.releasePos(i);
        this.releasePos(limit);
    }

    public int indexOf(Object o) {
        int i = 0;
        int iter = this.startPos();
        while ((iter = this.nextPos(iter)) != 0) {
            Object v = this.getPosPrevious(iter);
            if (o == null ? v == null : o.equals(v)) {
                this.releasePos(iter);
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int n = this.size();
        while (--n >= 0) {
            Object e = this.get(n);
            if (!(o == null ? e == null : o.equals(e))) continue;
            return n;
        }
        return -1;
    }

    public int nextMatching(int startPos, ElementPredicate type, int endPos, boolean descend) {
        if (descend) {
            throw this.unsupported("nextMatching with descend");
        }
        int ipos = startPos;
        do {
            if (this.compare(ipos, endPos) < 0) continue;
            return 0;
        } while (!type.isInstancePos(this, ipos = this.nextPos(ipos)));
        return ipos;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public final Enumeration elements() {
        return this.getIterator();
    }

    public final SeqPosition getIterator() {
        return this.getIterator(0);
    }

    public SeqPosition getIterator(int index) {
        return new SeqPosition(this, index, false);
    }

    public SeqPosition getIteratorAtPos(int ipos) {
        return new SeqPosition(this, this.copyPos(ipos));
    }

    public final Iterator iterator() {
        return this.getIterator();
    }

    public final ListIterator listIterator() {
        return this.getIterator(0);
    }

    public final ListIterator listIterator(int index) {
        return this.getIterator(index);
    }

    protected int addPos(int ipos, Object value) {
        throw this.unsupported("addPos");
    }

    public boolean add(Object o) {
        this.addPos(this.endPos(), o);
        return true;
    }

    public void add(int index, Object o) {
        int pos = this.createPos(index, false);
        this.addPos(pos, o);
        this.releasePos(pos);
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(int index, Collection c) {
        boolean changed = false;
        int pos = this.createPos(index, false);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            pos = this.addPos(pos, it.next());
            changed = true;
        }
        this.releasePos(pos);
        return changed;
    }

    public void removePos(int ipos, int count) {
        int rpos = this.createRelativePos(ipos, count, false);
        if (count >= 0) {
            this.removePosRange(ipos, rpos);
        } else {
            this.removePosRange(rpos, ipos);
        }
        this.releasePos(rpos);
    }

    protected void removePosRange(int ipos0, int ipos1) {
        throw this.unsupported("removePosRange");
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int ipos = this.createPos(index, false);
        Object result = this.getPosNext(ipos);
        this.removePos(ipos, 1);
        this.releasePos(ipos);
        return result;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        int ipos = this.createPos(index, false);
        this.removePos(ipos, 1);
        this.releasePos(ipos);
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        int iter = this.startPos();
        while ((iter = this.nextPos(iter)) != 0) {
            Object value = this.getPosPrevious(iter);
            if (!c.contains(value)) continue;
            this.removePos(iter, -1);
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        int iter = this.startPos();
        while ((iter = this.nextPos(iter)) != 0) {
            Object value = this.getPosPrevious(iter);
            if (c.contains(value)) continue;
            this.removePos(iter, -1);
            changed = true;
        }
        return changed;
    }

    public void clear() {
        this.removePos(this.startPos(), this.endPos());
    }

    protected boolean isAfterPos(int ipos) {
        return (ipos & 1) != 0;
    }

    public abstract int createPos(int var1, boolean var2);

    public int createRelativePos(int pos, int delta, boolean isAfter) {
        return this.createPos(this.nextIndex(pos) + delta, isAfter);
    }

    public int startPos() {
        return 0;
    }

    public int endPos() {
        return -1;
    }

    protected void releasePos(int ipos) {
    }

    public int copyPos(int ipos) {
        return ipos;
    }

    protected int getIndexDifference(int ipos1, int ipos0) {
        return this.nextIndex(ipos1) - this.nextIndex(ipos0);
    }

    protected int nextIndex(int ipos) {
        return this.getIndexDifference(ipos, this.startPos());
    }

    protected int fromEndIndex(int ipos) {
        return this.size() - this.nextIndex(ipos);
    }

    protected int getContainingSequenceSize(int ipos) {
        return this.size();
    }

    public boolean hasNext(int ipos) {
        return this.nextIndex(ipos) != this.size();
    }

    public int getNextKind(int ipos) {
        return this.hasNext(ipos) ? 32 : 0;
    }

    public String getNextTypeName(int ipos) {
        return null;
    }

    public Object getNextTypeObject(int ipos) {
        return null;
    }

    protected boolean hasPrevious(int ipos) {
        return this.nextIndex(ipos) != 0;
    }

    public int nextPos(int ipos) {
        if (!this.hasNext(ipos)) {
            return 0;
        }
        int next = this.createRelativePos(ipos, 1, true);
        this.releasePos(ipos);
        return next;
    }

    public int previousPos(int ipos) {
        if (!this.hasPrevious(ipos)) {
            return 0;
        }
        int next = this.createRelativePos(ipos, -1, false);
        this.releasePos(ipos);
        return next;
    }

    public final boolean gotoChildrenStart(TreePosition pos) {
        int ipos = this.firstChildPos(pos.getPos());
        if (ipos == 0) {
            return false;
        }
        pos.push(this, ipos);
        return true;
    }

    public int firstChildPos(int ipos) {
        return 0;
    }

    public int firstChildPos(int ipos, ElementPredicate predicate) {
        int child = this.firstChildPos(ipos);
        if (child == 0) {
            return 0;
        }
        if (predicate.isInstancePos(this, child)) {
            return child;
        }
        return this.nextMatching(child, predicate, this.endPos(), false);
    }

    public int firstAttributePos(int ipos) {
        return 0;
    }

    public int parentPos(int ipos) {
        return this.endPos();
    }

    protected boolean gotoParent(TreePosition pos) {
        if (pos.depth < 0) {
            return false;
        }
        pos.pop();
        return true;
    }

    public int getAttributeLength() {
        return 0;
    }

    public Object getAttribute(int index) {
        return null;
    }

    protected boolean gotoAttributesStart(TreePosition pos) {
        return false;
    }

    public Object getPosNext(int ipos) {
        if (!this.hasNext(ipos)) {
            return Sequence.eofValue;
        }
        return this.get(this.nextIndex(ipos));
    }

    public Object getPosPrevious(int ipos) {
        int index = this.nextIndex(ipos);
        if (index <= 0) {
            return Sequence.eofValue;
        }
        return this.get(index - 1);
    }

    protected void setPosNext(int ipos, Object value) {
        int index = this.nextIndex(ipos);
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.set(index, value);
    }

    protected void setPosPrevious(int ipos, Object value) {
        int index = this.nextIndex(ipos);
        if (index == 0) {
            throw new IndexOutOfBoundsException();
        }
        this.set(index - 1, value);
    }

    public final int nextIndex(SeqPosition pos) {
        return this.nextIndex(pos.ipos);
    }

    public boolean equals(int ipos1, int ipos2) {
        return this.compare(ipos1, ipos2) == 0;
    }

    public int compare(int ipos1, int ipos2) {
        int i2;
        int i1 = this.nextIndex(ipos1);
        return i1 < (i2 = this.nextIndex(ipos2)) ? -1 : (i1 > i2 ? 1 : 0);
    }

    public final int compare(SeqPosition i1, SeqPosition i2) {
        return this.compare(i1.ipos, i2.ipos);
    }

    public Object[] toArray() {
        int len = this.size();
        Object[] arr = new Object[len];
        int it = this.startPos();
        int i = 0;
        while ((it = this.nextPos(it)) != 0) {
            arr[i++] = this.getPosPrevious(it);
        }
        return arr;
    }

    public Object[] toArray(Object[] arr) {
        int alen = arr.length;
        int len = this.size();
        if (len > alen) {
            Class<?> componentType = arr.getClass().getComponentType();
            arr = (Object[])Array.newInstance(componentType, len);
            alen = len;
        }
        int it = this.startPos();
        int i = 0;
        while ((it = this.nextPos(it)) != 0) {
            arr[i] = this.getPosPrevious(it);
            ++i;
        }
        if (len < alen) {
            arr[len] = null;
        }
        return arr;
    }

    public int stableCompare(AbstractSequence other) {
        int id2;
        int id1 = System.identityHashCode(this);
        return id1 < (id2 = System.identityHashCode(other)) ? -1 : (id1 > id2 ? 1 : 0);
    }

    public static int compare(AbstractSequence seq1, int pos1, AbstractSequence seq2, int pos2) {
        if (seq1 == seq2) {
            return seq1.compare(pos1, pos2);
        }
        return seq1.stableCompare(seq2);
    }

    public int hashCode() {
        int hash = 1;
        int i = this.startPos();
        while ((i = this.nextPos(i)) != 0) {
            Object obj = this.getPosPrevious(i);
            hash = 31 * hash + (obj == null ? 0 : obj.hashCode());
        }
        return hash;
    }

    public boolean equals(Object o) {
        Object e2;
        Object e1;
        if (!(this instanceof List) || !(o instanceof List)) {
            return this == o;
        }
        Iterator it1 = this.iterator();
        Iterator it2 = ((List)o).iterator();
        do {
            boolean more2;
            boolean more1;
            if ((more1 = it1.hasNext()) != (more2 = it2.hasNext())) {
                return false;
            }
            if (!more1) {
                return true;
            }
            e1 = it1.next();
            e2 = it2.next();
        } while (!(e1 == null ? e2 != null : !e1.equals(e2)));
        return false;
    }

    public Sequence subSequence(SeqPosition start, SeqPosition end) {
        return this.subSequencePos(start.ipos, end.ipos);
    }

    protected Sequence subSequencePos(int ipos0, int ipos1) {
        return new SubSequence(this, ipos0, ipos1);
    }

    public List subList(int fromIx, int toIx) {
        return new SubSequence(this, this.createPos(fromIx, false), this.createPos(toIx, true));
    }

    public boolean consumeNext(int ipos, Consumer out) {
        int next = this.nextPos(ipos);
        if (next == 0) {
            return false;
        }
        this.consumePosRange(ipos, next, out);
        return true;
    }

    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int it = this.copyPos(iposStart);
        while (!this.equals(it, iposEnd)) {
            if (!this.hasNext(it)) {
                throw new RuntimeException();
            }
            out.writeObject(this.getPosNext(it));
            it = this.nextPos(it);
        }
        this.releasePos(it);
    }

    public void consume(Consumer out) {
        boolean isSequence = this instanceof Sequence;
        if (isSequence) {
            out.beginGroup("#sequence");
        }
        this.consumePosRange(this.startPos(), this.endPos(), out);
        if (isSequence) {
            out.endGroup();
        }
    }

    public void toString(String sep, StringBuffer sbuf) {
        boolean seen = false;
        int i = this.startPos();
        while ((i = this.nextPos(i)) != 0) {
            if (seen) {
                sbuf.append(sep);
            } else {
                seen = true;
            }
            sbuf.append(this.getPosPrevious(i));
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(100);
        if (this instanceof Sequence) {
            sbuf.append('[');
        }
        this.toString(", ", sbuf);
        if (this instanceof Sequence) {
            sbuf.append(']');
        }
        return sbuf.toString();
    }
}

