/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;

public class TypeSwitch
extends MethodProc
implements CanInline,
Inlineable {
    public static final TypeSwitch typeSwitch = new TypeSwitch("typeswitch");

    public TypeSwitch(String name) {
        this.setName(name);
    }

    public int numArgs() {
        return -4094;
    }

    public void apply(CallContext ctx) throws Throwable {
        Object[] args = ctx.getArgs();
        Object selector = args[0];
        int n = args.length - 1;
        for (int i = 1; i < n; ++i) {
            MethodProc caseProc = (MethodProc)args[i];
            int m = caseProc.match1(selector, ctx);
            if (m < 0) continue;
            return;
        }
        Procedure defaultProc = (Procedure)args[n];
        defaultProc.check1(selector, ctx);
    }

    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Expression[] args = exp.getArgs();
        for (int i = 1; i < args.length; ++i) {
            if (!(args[i] instanceof LambdaExp)) continue;
            LambdaExp lexp = (LambdaExp)args[i];
            lexp.setInlineOnly(true);
            lexp.returnContinuation = exp;
        }
        return exp;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        LambdaExp lambda;
        int i;
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        code.pushScope();
        Variable selector = code.addLocal(Type.pointer_type);
        args[0].compile(comp, Target.pushObject);
        code.emitStore(selector);
        for (i = 1; i < args.length - 1; ++i) {
            if (i > 1) {
                code.emitElse();
            }
            if (args[i] instanceof LambdaExp) {
                lambda = (LambdaExp)args[i];
                Declaration param = lambda.firstDecl();
                Type type = param.getType();
                param.allocateVariable(code);
                if (type instanceof TypeValue) {
                    ((TypeValue)((Object)type)).emitTestIf(selector, param, comp);
                } else {
                    code.emitLoad(selector);
                    type.emitIsInstance(code);
                    code.emitIfIntNotZero();
                    code.emitLoad(selector);
                    param.compileStore(comp);
                }
            } else {
                throw new Error("not implemented: typeswitch arg not LambdaExp");
            }
            lambda.allocChildClasses(comp);
            lambda.body.compileWithPosition(comp, target);
        }
        i = args.length - 2;
        if (i > 0) {
            code.emitElse();
        }
        lambda = (LambdaExp)args[args.length - 1];
        lambda.allocChildClasses(comp);
        lambda.body.compileWithPosition(comp, target);
        while (--i >= 0) {
            code.emitFi();
        }
        code.popScope();
    }

    public Type getReturnType(Expression[] args) {
        return Type.pointer_type;
    }
}

