/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.kawa.functions.Arithmetic;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XDataType;
import gnu.kawa.xml.XIntegerType;
import gnu.mapping.Procedure1;
import gnu.mapping.Values;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.xml.TextUtils;
import java.math.BigDecimal;

public class NumberValue
extends Procedure1 {
    public static final NumberValue numberValue = new NumberValue();
    public static final Double NaN = new Double(Double.NaN);

    public static boolean isNaN(Object object2) {
        return (object2 instanceof Double || object2 instanceof Float || object2 instanceof DFloNum) && Double.isNaN(((Number)object2).doubleValue());
    }

    public Object apply1(Object object2) {
        if (object2 != Values.empty && object2 != null) {
            try {
                return NumberValue.numberValue(object2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return NaN;
    }

    public static Number numberCast(Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return null;
        }
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.startPos();
            int n2 = 0;
            while ((n = values.nextPos(n)) != 0) {
                if (n2 > 0) {
                    throw new ClassCastException("non-singleton sequence cast to number");
                }
                object2 = values.getPosPrevious(n);
                ++n2;
            }
        }
        if (object2 instanceof KNode || object2 instanceof UntypedAtomic) {
            return (Double)XDataType.doubleType.valueOf(TextUtils.stringValue(object2));
        }
        return (Number)object2;
    }

    public static Object numberValue(Object object2) {
        double d;
        if ((object2 = KNode.atomicValue(object2)) instanceof UntypedAtomic || object2 instanceof String) {
            try {
                return XDataType.doubleType.valueOf(TextUtils.stringValue(object2));
            }
            catch (Throwable throwable) {
                d = Double.NaN;
            }
        } else {
            d = object2 instanceof Number && (object2 instanceof RealNum || !(object2 instanceof Numeric)) ? ((Number)object2).doubleValue() : Double.NaN;
        }
        return XDataType.makeDouble(d);
    }

    public static Object abs(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        if ((object2 = NumberValue.numberCast(object2)) instanceof Double) {
            Double d = (Double)object2;
            double d2 = d;
            long l = Double.doubleToRawLongBits(d2);
            if (l >= 0L) {
                return d;
            }
            d2 = Double.longBitsToDouble(l &= Long.MAX_VALUE);
            return d2;
        }
        if (object2 instanceof Float) {
            Float f = (Float)object2;
            float f2 = f.floatValue();
            int n = Float.floatToRawIntBits(f2);
            if (n >= 0) {
                return f;
            }
            f2 = Float.intBitsToFloat(n &= Integer.MAX_VALUE);
            return Float.valueOf(f2);
        }
        if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object2;
            if (bigDecimal.signum() < 0) {
                bigDecimal = bigDecimal.negate();
            }
            return bigDecimal;
        }
        return ((Numeric)object2).abs();
    }

    public static Object floor(Object object2) {
        Number number = NumberValue.numberCast(object2);
        if (number == null) {
            return object2;
        }
        if (number instanceof Double) {
            return XDataType.makeDouble(Math.floor((Double)number));
        }
        if (number instanceof Float) {
            return XDataType.makeFloat((float)Math.floor(((Float)number).floatValue()));
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            return Arithmetic.asIntNum(bigDecimal.divide(XDataType.DECIMAL_ONE, 0, 3).toBigInteger());
        }
        return ((RealNum)number).toInt(1);
    }

    public static Object ceiling(Object object2) {
        Number number = NumberValue.numberCast(object2);
        if (number == null) {
            return object2;
        }
        if (number instanceof Double) {
            return XDataType.makeDouble(Math.ceil((Double)number));
        }
        if (number instanceof Float) {
            return XDataType.makeFloat((float)Math.ceil(((Float)number).floatValue()));
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            return Arithmetic.asIntNum(bigDecimal.divide(XDataType.DECIMAL_ONE, 0, 2).toBigInteger());
        }
        return ((RealNum)number).toInt(2);
    }

    public static Object round(Object object2) {
        Number number = NumberValue.numberCast(object2);
        if (number == null) {
            return object2;
        }
        if (number instanceof Double) {
            double d = (Double)number;
            d = d >= -0.5 && d <= 0.0 && (d < 0.0 || Double.doubleToLongBits(d) < 0L) ? -0.0 : Math.floor(d + 0.5);
            return XDataType.makeDouble(d);
        }
        if (number instanceof Float) {
            float f = ((Float)number).floatValue();
            f = (double)f >= -0.5 && (double)f <= 0.0 && ((double)f < 0.0 || Float.floatToIntBits(f) < 0) ? -0.0f : (float)Math.floor((double)f + 0.5);
            return XDataType.makeFloat(f);
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            int n = bigDecimal.signum() >= 0 ? 4 : 5;
            bigDecimal = bigDecimal.divide(XDataType.DECIMAL_ONE, 0, n);
            return Arithmetic.asIntNum(bigDecimal.toBigInteger());
        }
        return ((RealNum)number).toInt(4);
    }

    public static Object roundHalfToEven(Object object2, IntNum intNum) {
        double d;
        Number number = NumberValue.numberCast(object2);
        if (number == null) {
            return object2;
        }
        if ((object2 instanceof Double || object2 instanceof Float) && ((d = ((Number)object2).doubleValue()) == 0.0 || Double.isInfinite(d) || Double.isNaN(d))) {
            return object2;
        }
        BigDecimal bigDecimal = (BigDecimal)XDataType.decimalType.cast(number);
        int n = intNum.intValue();
        bigDecimal = bigDecimal.setScale(n, 6);
        if (number instanceof Double) {
            return XDataType.makeDouble(bigDecimal.doubleValue());
        }
        if (number instanceof Float) {
            return XDataType.makeFloat(bigDecimal.floatValue());
        }
        if (number instanceof IntNum) {
            return XIntegerType.integerType.cast(bigDecimal);
        }
        return bigDecimal;
    }

    public static Object roundHalfToEven(Object object2) {
        return NumberValue.roundHalfToEven(object2, IntNum.zero());
    }
}

