package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAreaHotSpotMetrics invokes the cdrs.ListAreaHotSpotMetrics API synchronously
func (client *Client) ListAreaHotSpotMetrics(request *ListAreaHotSpotMetricsRequest) (response *ListAreaHotSpotMetricsResponse, err error) {
	response = CreateListAreaHotSpotMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAreaHotSpotMetricsWithChan invokes the cdrs.ListAreaHotSpotMetrics API asynchronously
func (client *Client) ListAreaHotSpotMetricsWithChan(request *ListAreaHotSpotMetricsRequest) (<-chan *ListAreaHotSpotMetricsResponse, <-chan error) {
	responseChan := make(chan *ListAreaHotSpotMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAreaHotSpotMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAreaHotSpotMetricsWithCallback invokes the cdrs.ListAreaHotSpotMetrics API asynchronously
func (client *Client) ListAreaHotSpotMetricsWithCallback(request *ListAreaHotSpotMetricsRequest, callback func(response *ListAreaHotSpotMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAreaHotSpotMetricsResponse
		var err error
		defer close(result)
		response, err = client.ListAreaHotSpotMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAreaHotSpotMetricsRequest is the request struct for api ListAreaHotSpotMetrics
type ListAreaHotSpotMetricsRequest struct {
	*requests.RpcRequest
	Schema     string `position:"Body" name:"Schema"`
	CorpId     string `position:"Body" name:"CorpId"`
	EndTime    string `position:"Body" name:"EndTime"`
	StartTime  string `position:"Body" name:"StartTime"`
	DeviceId   string `position:"Body" name:"DeviceId"`
	PageNumber string `position:"Body" name:"PageNumber"`
	PageSize   string `position:"Body" name:"PageSize"`
	PersonId   string `position:"Body" name:"PersonId"`
}

// ListAreaHotSpotMetricsResponse is the response struct for api ListAreaHotSpotMetrics
type ListAreaHotSpotMetricsResponse struct {
	*responses.BaseResponse
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber string     `json:"PageNumber" xml:"PageNumber"`
	PageSize   string     `json:"PageSize" xml:"PageSize"`
	TotalCount string     `json:"TotalCount" xml:"TotalCount"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateListAreaHotSpotMetricsRequest creates a request to invoke ListAreaHotSpotMetrics API
func CreateListAreaHotSpotMetricsRequest() (request *ListAreaHotSpotMetricsRequest) {
	request = &ListAreaHotSpotMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListAreaHotSpotMetrics", "", "")
	request.Method = requests.POST
	return
}

// CreateListAreaHotSpotMetricsResponse creates a response to parse from ListAreaHotSpotMetrics response
func CreateListAreaHotSpotMetricsResponse() (response *ListAreaHotSpotMetricsResponse) {
	response = &ListAreaHotSpotMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
