package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRangeDevice invokes the cdrs.ListRangeDevice API synchronously
func (client *Client) ListRangeDevice(request *ListRangeDeviceRequest) (response *ListRangeDeviceResponse, err error) {
	response = CreateListRangeDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ListRangeDeviceWithChan invokes the cdrs.ListRangeDevice API asynchronously
func (client *Client) ListRangeDeviceWithChan(request *ListRangeDeviceRequest) (<-chan *ListRangeDeviceResponse, <-chan error) {
	responseChan := make(chan *ListRangeDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRangeDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRangeDeviceWithCallback invokes the cdrs.ListRangeDevice API asynchronously
func (client *Client) ListRangeDeviceWithCallback(request *ListRangeDeviceRequest, callback func(response *ListRangeDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRangeDeviceResponse
		var err error
		defer close(result)
		response, err = client.ListRangeDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRangeDeviceRequest is the request struct for api ListRangeDevice
type ListRangeDeviceRequest struct {
	*requests.RpcRequest
	CorpId       string           `position:"Body" name:"CorpId"`
	PageNumber   requests.Integer `position:"Body" name:"PageNumber"`
	DataSourceId string           `position:"Body" name:"DataSourceId"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	Radius       requests.Integer `position:"Body" name:"Radius"`
}

// ListRangeDeviceResponse is the response struct for api ListRangeDevice
type ListRangeDeviceResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListRangeDeviceRequest creates a request to invoke ListRangeDevice API
func CreateListRangeDeviceRequest() (request *ListRangeDeviceRequest) {
	request = &ListRangeDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListRangeDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateListRangeDeviceResponse creates a response to parse from ListRangeDevice response
func CreateListRangeDeviceResponse() (response *ListRangeDeviceResponse) {
	response = &ListRangeDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
