package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMeasurementData invokes the ens.DescribeMeasurementData API synchronously
func (client *Client) DescribeMeasurementData(request *DescribeMeasurementDataRequest) (response *DescribeMeasurementDataResponse, err error) {
	response = CreateDescribeMeasurementDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMeasurementDataWithChan invokes the ens.DescribeMeasurementData API asynchronously
func (client *Client) DescribeMeasurementDataWithChan(request *DescribeMeasurementDataRequest) (<-chan *DescribeMeasurementDataResponse, <-chan error) {
	responseChan := make(chan *DescribeMeasurementDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMeasurementData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMeasurementDataWithCallback invokes the ens.DescribeMeasurementData API asynchronously
func (client *Client) DescribeMeasurementDataWithCallback(request *DescribeMeasurementDataRequest, callback func(response *DescribeMeasurementDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMeasurementDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeMeasurementData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMeasurementDataRequest is the request struct for api DescribeMeasurementData
type DescribeMeasurementDataRequest struct {
	*requests.RpcRequest
	StartDate string `position:"Query" name:"StartDate"`
	EndDate   string `position:"Query" name:"EndDate"`
}

// DescribeMeasurementDataResponse is the response struct for api DescribeMeasurementData
type DescribeMeasurementDataResponse struct {
	*responses.BaseResponse
	RequestId        string                                    `json:"RequestId" xml:"RequestId"`
	MeasurementDatas MeasurementDatasInDescribeMeasurementData `json:"MeasurementDatas" xml:"MeasurementDatas"`
}

// CreateDescribeMeasurementDataRequest creates a request to invoke DescribeMeasurementData API
func CreateDescribeMeasurementDataRequest() (request *DescribeMeasurementDataRequest) {
	request = &DescribeMeasurementDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeMeasurementData", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMeasurementDataResponse creates a response to parse from DescribeMeasurementData response
func CreateDescribeMeasurementDataResponse() (response *DescribeMeasurementDataResponse) {
	response = &DescribeMeasurementDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
