package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDirQuota invokes the nas.SetDirQuota API synchronously
func (client *Client) SetDirQuota(request *SetDirQuotaRequest) (response *SetDirQuotaResponse, err error) {
	response = CreateSetDirQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// SetDirQuotaWithChan invokes the nas.SetDirQuota API asynchronously
func (client *Client) SetDirQuotaWithChan(request *SetDirQuotaRequest) (<-chan *SetDirQuotaResponse, <-chan error) {
	responseChan := make(chan *SetDirQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDirQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDirQuotaWithCallback invokes the nas.SetDirQuota API asynchronously
func (client *Client) SetDirQuotaWithCallback(request *SetDirQuotaRequest, callback func(response *SetDirQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDirQuotaResponse
		var err error
		defer close(result)
		response, err = client.SetDirQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDirQuotaRequest is the request struct for api SetDirQuota
type SetDirQuotaRequest struct {
	*requests.RpcRequest
	QuotaType      string           `position:"Query" name:"QuotaType"`
	UserId         string           `position:"Query" name:"UserId"`
	FileCountLimit requests.Integer `position:"Query" name:"FileCountLimit"`
	Path           string           `position:"Query" name:"Path"`
	SizeLimit      requests.Integer `position:"Query" name:"SizeLimit"`
	FileSystemId   string           `position:"Query" name:"FileSystemId"`
	UserType       string           `position:"Query" name:"UserType"`
}

// SetDirQuotaResponse is the response struct for api SetDirQuota
type SetDirQuotaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetDirQuotaRequest creates a request to invoke SetDirQuota API
func CreateSetDirQuotaRequest() (request *SetDirQuotaRequest) {
	request = &SetDirQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "SetDirQuota", "", "")
	request.Method = requests.POST
	return
}

// CreateSetDirQuotaResponse creates a response to parse from SetDirQuota response
func CreateSetDirQuotaResponse() (response *SetDirQuotaResponse) {
	response = &SetDirQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
