package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpInfo invokes the sas.DescribeIpInfo API synchronously
func (client *Client) DescribeIpInfo(request *DescribeIpInfoRequest) (response *DescribeIpInfoResponse, err error) {
	response = CreateDescribeIpInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpInfoWithChan invokes the sas.DescribeIpInfo API asynchronously
func (client *Client) DescribeIpInfoWithChan(request *DescribeIpInfoRequest) (<-chan *DescribeIpInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeIpInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpInfoWithCallback invokes the sas.DescribeIpInfo API asynchronously
func (client *Client) DescribeIpInfoWithCallback(request *DescribeIpInfoRequest, callback func(response *DescribeIpInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpInfoRequest is the request struct for api DescribeIpInfo
type DescribeIpInfoRequest struct {
	*requests.RpcRequest
	Ip       string `position:"Query" name:"Ip"`
	SourceIp string `position:"Query" name:"SourceIp"`
	Field    string `position:"Query" name:"Field"`
}

// DescribeIpInfoResponse is the response struct for api DescribeIpInfo
type DescribeIpInfoResponse struct {
	*responses.BaseResponse
	RequestId               string `json:"RequestId" xml:"RequestId"`
	Ip                      string `json:"ip" xml:"ip"`
	Geo                     string `json:"geo" xml:"geo"`
	IsProxy                 string `json:"is_proxy" xml:"is_proxy"`
	GmtLastTor              string `json:"gmt_last_tor" xml:"gmt_last_tor"`
	TorDayTrace             string `json:"tor_day_trace" xml:"tor_day_trace"`
	TotalDayCntTor          string `json:"total_day_cnt_tor" xml:"total_day_cnt_tor"`
	DayCnt7dTor             string `json:"day_cnt_7d_tor" xml:"day_cnt_7d_tor"`
	DayCnt30dTor            string `json:"day_cnt_30d_tor" xml:"day_cnt_30d_tor"`
	IsTor                   string `json:"is_tor" xml:"is_tor"`
	GmtLastWebAttack        string `json:"gmt_last_web_attack" xml:"gmt_last_web_attack"`
	WebAttackDayTrace       string `json:"web_attack_day_trace" xml:"web_attack_day_trace"`
	TotalDayCntWebAttack    string `json:"total_day_cnt_web_attack" xml:"total_day_cnt_web_attack"`
	DayCnt7dWebAttack       string `json:"day_cnt_7d_web_attack" xml:"day_cnt_7d_web_attack"`
	DayCnt30dWebAttack      string `json:"day_cnt_30d_web_attack" xml:"day_cnt_30d_web_attack"`
	IsWebAttack             string `json:"is_web_attack" xml:"is_web_attack"`
	GmtLastProxy            string `json:"gmt_last_proxy" xml:"gmt_last_proxy"`
	ProxyDayTrace           string `json:"proxy_day_trace" xml:"proxy_day_trace"`
	IsProxy1d               string `json:"is_proxy_1d" xml:"is_proxy_1d"`
	IsProxy7d               string `json:"is_proxy_7d" xml:"is_proxy_7d"`
	IsTor1d                 string `json:"is_tor_1d" xml:"is_tor_1d"`
	IsTor7d                 string `json:"is_tor_7d" xml:"is_tor_7d"`
	IsWebAttack1d           string `json:"is_web_attack_1d" xml:"is_web_attack_1d"`
	IsWebAttack7d           string `json:"is_web_attack_7d" xml:"is_web_attack_7d"`
	IsWebAttack30d          string `json:"is_web_attack_30d" xml:"is_web_attack_30d"`
	Province                string `json:"province" xml:"province"`
	City                    string `json:"city" xml:"city"`
	Isp                     string `json:"isp" xml:"isp"`
	Country                 string `json:"country" xml:"country"`
	GmtLastNat              string `json:"gmt_last_nat" xml:"gmt_last_nat"`
	NatDayTrace             string `json:"nat_day_trace" xml:"nat_day_trace"`
	IsNat                   string `json:"is_nat" xml:"is_nat"`
	IsNat1d                 string `json:"is_nat_1d" xml:"is_nat_1d"`
	IsNat7d                 string `json:"is_nat_7d" xml:"is_nat_7d"`
	GmtFirstMiningPool      string `json:"gmt_first_mining_pool" xml:"gmt_first_mining_pool"`
	GmtLastMiningPool       string `json:"gmt_last_mining_pool" xml:"gmt_last_mining_pool"`
	MiningPoolDayTrace      string `json:"mining_pool_day_trace" xml:"mining_pool_day_trace"`
	IsMiningPool            string `json:"is_mining_pool" xml:"is_mining_pool"`
	IsMiningPool1d          string `json:"is_mining_pool_1d" xml:"is_mining_pool_1d"`
	IsMiningPool7d          string `json:"is_mining_pool_7d" xml:"is_mining_pool_7d"`
	GmtFirstC2              string `json:"gmt_first_c2" xml:"gmt_first_c2"`
	GmtLastC2               string `json:"gmt_last_c2" xml:"gmt_last_c2"`
	C2DayTrace              string `json:"c2_day_trace" xml:"c2_day_trace"`
	IsC2                    string `json:"is_c2" xml:"is_c2"`
	IsC21d                  string `json:"is_c2_1d" xml:"is_c2_1d"`
	IsC27d                  string `json:"is_c2_7d" xml:"is_c2_7d"`
	GmtLastMaliciousSource  string `json:"gmt_last_malicious_source" xml:"gmt_last_malicious_source"`
	MaliciousSourceDayTrace string `json:"malicious_source_day_trace" xml:"malicious_source_day_trace"`
	IsMaliciousSource       string `json:"is_malicious_source" xml:"is_malicious_source"`
	IsMaliciousSource1d     string `json:"is_malicious_source_1d" xml:"is_malicious_source_1d"`
	IsMaliciousSource7d     string `json:"is_malicious_source_7d" xml:"is_malicious_source_7d"`
	IsMaliciousSource30d    string `json:"is_malicious_source_30d" xml:"is_malicious_source_30d"`
	IsIdc                   string `json:"is_idc" xml:"is_idc"`
	IdcName                 string `json:"idc_name" xml:"idc_name"`
	IsMaliciousLogin        string `json:"is_malicious_login" xml:"is_malicious_login"`
	GmtLastMaliciousLogin   string `json:"gmt_last_malicious_login" xml:"gmt_last_malicious_login"`
	MaliciousLoginDayTrace  string `json:"malicious_login_day_trace" xml:"malicious_login_day_trace"`
	IsMaliciousLogin1d      string `json:"is_malicious_login_1d" xml:"is_malicious_login_1d"`
	IsMaliciousLogin7d      string `json:"is_malicious_login_7d" xml:"is_malicious_login_7d"`
	MaliciousScore          string `json:"malicious_score" xml:"malicious_score"`
	Tags                    string `json:"tags" xml:"tags"`
	Rdns                    string `json:"rdns" xml:"rdns"`
}

// CreateDescribeIpInfoRequest creates a request to invoke DescribeIpInfo API
func CreateDescribeIpInfoRequest() (request *DescribeIpInfoRequest) {
	request = &DescribeIpInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeIpInfo", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIpInfoResponse creates a response to parse from DescribeIpInfo response
func CreateDescribeIpInfoResponse() (response *DescribeIpInfoResponse) {
	response = &DescribeIpInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
