package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServiceMesh invokes the servicemesh.CreateServiceMesh API synchronously
func (client *Client) CreateServiceMesh(request *CreateServiceMeshRequest) (response *CreateServiceMeshResponse, err error) {
	response = CreateCreateServiceMeshResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceMeshWithChan invokes the servicemesh.CreateServiceMesh API asynchronously
func (client *Client) CreateServiceMeshWithChan(request *CreateServiceMeshRequest) (<-chan *CreateServiceMeshResponse, <-chan error) {
	responseChan := make(chan *CreateServiceMeshResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServiceMesh(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceMeshWithCallback invokes the servicemesh.CreateServiceMesh API asynchronously
func (client *Client) CreateServiceMeshWithCallback(request *CreateServiceMeshRequest, callback func(response *CreateServiceMeshResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceMeshResponse
		var err error
		defer close(result)
		response, err = client.CreateServiceMesh(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceMeshRequest is the request struct for api CreateServiceMesh
type CreateServiceMeshRequest struct {
	*requests.RpcRequest
	ProxyRequestCPU               string           `position:"Body" name:"ProxyRequestCPU"`
	OPALimitCPU                   string           `position:"Body" name:"OPALimitCPU"`
	OpenAgentPolicy               requests.Boolean `position:"Body" name:"OpenAgentPolicy"`
	OpaEnabled                    requests.Boolean `position:"Body" name:"OpaEnabled"`
	ProxyLimitMemory              string           `position:"Body" name:"ProxyLimitMemory"`
	StrictMTLS                    requests.Boolean `position:"Body" name:"StrictMTLS"`
	OPALogLevel                   string           `position:"Body" name:"OPALogLevel"`
	ExcludeIPRanges               string           `position:"Body" name:"ExcludeIPRanges"`
	IstioVersion                  string           `position:"Body" name:"IstioVersion"`
	Tracing                       requests.Boolean `position:"Body" name:"Tracing"`
	IncludeIPRanges               string           `position:"Body" name:"IncludeIPRanges"`
	ExcludeInboundPorts           string           `position:"Body" name:"ExcludeInboundPorts"`
	OPALimitMemory                string           `position:"Body" name:"OPALimitMemory"`
	VSwitches                     string           `position:"Body" name:"VSwitches"`
	CADisableSecretAutoGeneration requests.Boolean `position:"Body" name:"CADisableSecretAutoGeneration"`
	CAListenedNamespaces          string           `position:"Body" name:"CAListenedNamespaces"`
	ProxyLimitCPU                 string           `position:"Body" name:"ProxyLimitCPU"`
	ProxyRequestMemory            string           `position:"Body" name:"ProxyRequestMemory"`
	Name                          string           `position:"Body" name:"Name"`
	Telemetry                     requests.Boolean `position:"Body" name:"Telemetry"`
	OPARequestCPU                 string           `position:"Body" name:"OPARequestCPU"`
	OPARequestMemory              string           `position:"Body" name:"OPARequestMemory"`
	EnableAudit                   requests.Boolean `position:"Body" name:"EnableAudit"`
	ClusterDomain                 string           `position:"Body" name:"ClusterDomain"`
	LocalityLoadBalancing         requests.Boolean `position:"Body" name:"LocalityLoadBalancing"`
	ApiServerPublicEip            requests.Boolean `position:"Body" name:"ApiServerPublicEip"`
	TraceSampling                 requests.Float   `position:"Body" name:"TraceSampling"`
	AppNamespaces                 string           `position:"Body" name:"AppNamespaces"`
	PilotPublicEip                requests.Boolean `position:"Body" name:"PilotPublicEip"`
	AuditProject                  string           `position:"Body" name:"AuditProject"`
	OutboundTrafficPolicy         string           `position:"Body" name:"OutboundTrafficPolicy"`
	VpcId                         string           `position:"Body" name:"VpcId"`
	ExcludeOutboundPorts          string           `position:"Body" name:"ExcludeOutboundPorts"`
}

// CreateServiceMeshResponse is the response struct for api CreateServiceMesh
type CreateServiceMeshResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ServiceMeshId string `json:"ServiceMeshId" xml:"ServiceMeshId"`
}

// CreateCreateServiceMeshRequest creates a request to invoke CreateServiceMesh API
func CreateCreateServiceMeshRequest() (request *CreateServiceMeshRequest) {
	request = &CreateServiceMeshRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "CreateServiceMesh", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateServiceMeshResponse creates a response to parse from CreateServiceMesh response
func CreateCreateServiceMeshResponse() (response *CreateServiceMeshResponse) {
	response = &CreateServiceMeshResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
